/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DTemplateFieldCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DTextTemplateField;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameterCodec;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DTextTemplateFieldCodec {
    private DTextTemplateFieldCodec() {
    }

    public static Element encode(DTextTemplateField dTemplateField, Element parent) throws AdvSearchException {
        Document doc = parent.getOwnerDocument();
        Element me = (Element)parent.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Field"));
        me.setAttribute("xsi:type", "TextTemplateField");
        DTemplateFieldCodec.encodeStandardValues(dTemplateField, me);
        if (dTemplateField.getParameter() != null) {
            try {
                DTextFieldParameterCodec.encode(dTemplateField.getParameter(), me);
            }
            catch (DSearchException dSearchException) {
                throw new AdvSearchException("unable to encode parameter of template field [" + dTemplateField.getFieldNo() + "]");
            }
        }
        return me;
    }

    public static DTextTemplateField decode(Element element) throws AdvSearchException {
        DTextTemplateField dTemplateField = new DTextTemplateField();
        DTemplateFieldCodec.decodeStandardValues(dTemplateField, element);
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("Parameter".equals(nl.item(i).getLocalName())) {
                try {
                    dTemplateField.setParameter((DTextFieldParameter)DTextFieldParameterCodec.decode((Element)nl.item(i)));
                }
                catch (DSearchException dSearchException) {
                    throw new AdvSearchException("unable to decode parameter of template field [" + dTemplateField.getFieldNo() + "]");
                }
            }
            ++i;
        }
        return dTemplateField;
    }
}

