/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.indexstructure;

import java.util.Iterator;
import org.eclipse.smila.search.lucene.messages.indexstructure.DAnalyzerCodec;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexField;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexFieldCodec;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexStructure;
import org.eclipse.smila.search.utils.indexstructure.ISException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DIndexStructureCodec {
    public static final String NS = "http://www.anyfinder.de/IndexStructure";

    private DIndexStructureCodec() {
    }

    public static Element encode(DIndexStructure dIS, Element element) throws ISException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS(NS, "IndexStructure");
        Attr attr = null;
        if (dIS.getName() != null) {
            attr = doc.createAttribute("Name");
            attr.setValue(dIS.getName());
            el.setAttributeNode(attr);
        }
        DAnalyzerCodec.encode(dIS.getAnalyzer(), el);
        Iterator<org.eclipse.smila.search.utils.indexstructure.DIndexField> it = dIS.getFields();
        while (it.hasNext()) {
            DIndexFieldCodec.encode((DIndexField)it.next(), el);
        }
        element.appendChild(el);
        return el;
    }

    public static DIndexStructure decode(Element element) throws ISException {
        DIndexStructure dIndexStructure = new DIndexStructure();
        dIndexStructure.setName(element.getAttribute("Name"));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                Element node = (Element)nl.item(i);
                if (node.getLocalName().equals("Analyzer")) {
                    dIndexStructure.setAnalyzer(DAnalyzerCodec.decode(node));
                } else if (node.getLocalName().equals("IndexField")) {
                    dIndexStructure.addField(DIndexFieldCodec.decode(node));
                }
            }
            ++i;
        }
        return dIndexStructure;
    }
}

