/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.templates.transformer;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.smila.search.lucene.messages.advsearch.DOP1;
import org.eclipse.smila.search.lucene.messages.advsearch.DOPN;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.lucene.messages.advsearch.DTermContent;
import org.eclipse.smila.search.lucene.messages.advsearch.DTextField;
import org.eclipse.smila.search.lucene.templates.transformer.PhraseInformation;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.templates.NodeTransformer;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.utils.advsearch.ITermContent;
import org.eclipse.smila.search.utils.search.DField;

public class SynonymNodeTransformer
extends NodeTransformer {
    public ITermContent transformNode(DField dField) throws NodeTransformerException {
        if (dField == null) {
            throw new NodeTransformerException("parameter must not be null [dField]");
        }
        if (!(dField instanceof org.eclipse.smila.search.utils.search.DTextField)) {
            throw new NodeTransformerException("node transformer supports text fields only");
        }
        org.eclipse.smila.search.utils.search.DTextField textField = (org.eclipse.smila.search.utils.search.DTextField)dField;
        String text = textField.getText();
        String[] tokens = SynonymNodeTransformer.splitByWholeSeparator(text, "} {", 0);
        Hashtable<PhraseInformation, Set<String>> tokensAndSynonyms = new Hashtable<PhraseInformation, Set<String>>();
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            if (token.startsWith("{")) {
                token = token.substring(1);
            }
            if (token.endsWith("}")) {
                token = token.substring(0, token.length() - 1);
            }
            PhraseInformation name = null;
            String synonym = null;
            if (token.contains("#-->#")) {
                String[] items = SynonymNodeTransformer.splitByWholeSeparator(token, "#-->#", 0);
                name = new PhraseInformation(items[0]);
                synonym = items[1];
            } else {
                name = new PhraseInformation(token);
            }
            Set<Object> synonyms = null;
            if (tokensAndSynonyms.containsKey(name)) {
                synonyms = tokensAndSynonyms.get(name);
            } else {
                synonyms = new HashSet();
                tokensAndSynonyms.put(name, synonyms);
            }
            if (synonym != null) {
                synonyms.add(synonym);
            }
            ++i;
        }
        if (tokensAndSynonyms.size() > 1) {
            DOPN opMain = new DOPN();
            DTextFieldParameter textFieldParameter = (DTextFieldParameter)textField.getParameter();
            DTextFieldParameter.DOperator operator = textFieldParameter.getOperator();
            if (operator == DTextFieldParameter.DOperator.AND || operator == DTextFieldParameter.DOperator.PHRASE) {
                opMain.setOperation("AND");
            } else if (operator == DTextFieldParameter.DOperator.OR) {
                opMain.setOperation("OR");
            }
            Enumeration<PhraseInformation> phraseInformations = tokensAndSynonyms.keys();
            while (phraseInformations.hasMoreElements()) {
                PhraseInformation phraseInformation = phraseInformations.nextElement();
                ITermContent termContent = this.preparePhrase(tokensAndSynonyms, textField, phraseInformation);
                opMain.addTerm(new DTerm(termContent));
            }
            return opMain;
        }
        if (tokensAndSynonyms.size() == 1) {
            PhraseInformation phraseInformation = (PhraseInformation)tokensAndSynonyms.keySet().iterator().next();
            return this.preparePhrase(tokensAndSynonyms, textField, phraseInformation);
        }
        throw new NodeTransformerException("no search term available");
    }

    private ITermContent preparePhrase(Hashtable<PhraseInformation, Set<String>> tokensAndSynonyms, org.eclipse.smila.search.utils.search.DTextField textField, PhraseInformation phraseInformation) {
        Set<String> synonyms = tokensAndSynonyms.get(phraseInformation);
        DTermContent termContent = null;
        if (synonyms.size() > 0) {
            DOPN opOR = new DOPN();
            opOR.setOperation("OR");
            opOR.addTerm(new DTerm(new DTextField(textField.getFieldNo(), phraseInformation.getPhrase(), false, true, 0)));
            for (String synonym : synonyms) {
                opOR.addTerm(new DTerm(new DTextField(textField.getFieldNo(), synonym, false, false, 0)));
            }
            termContent = opOR;
        } else {
            termContent = new DTextField(textField.getFieldNo(), phraseInformation.getPhrase(), false, true, 0);
        }
        if (phraseInformation.isFilter()) {
            termContent = new DOP1("NOT", new DTerm((ITermContent)termContent));
        }
        return termContent;
    }

    public static String[] splitByWholeSeparator(String str, String separator, int max) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        int separatorLength = separator.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(separator, beg);
            if (end > -1) {
                if (end > beg) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                        continue;
                    }
                    substrings.add(str.substring(beg, end));
                    beg = end + separatorLength;
                    continue;
                }
                beg = end + separatorLength;
                continue;
            }
            substrings.add(str.substring(beg));
            end = len;
        }
        return substrings.toArray(new String[substrings.size()]);
    }
}

