/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.messages.fieldrequest;

import java.util.Iterator;
import org.eclipse.smila.search.messages.fieldrequest.DAnyFinderFieldRequest;
import org.eclipse.smila.search.messages.fieldrequest.DField;
import org.eclipse.smila.search.messages.fieldrequest.DFieldCodec;
import org.eclipse.smila.search.messages.fieldrequest.FieldRequestException;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DAnyFinderFieldRequestCodec {
    public static final String NS = "http://www.anyfinder.de/FieldRequest";

    private DAnyFinderFieldRequestCodec() {
    }

    public static Document encode(DAnyFinderFieldRequest fieldRequest) throws FieldRequestException {
        return DAnyFinderFieldRequestCodec.encode(fieldRequest, XMLUtils.getDocument());
    }

    public static Document encode(DAnyFinderFieldRequest fieldRequest, Document doc) throws FieldRequestException {
        if (fieldRequest == null) {
            throw new FieldRequestException("parameter must not be null [fieldRequest]");
        }
        if (doc == null) {
            throw new FieldRequestException("parameter must not be null [doc]");
        }
        Element root = doc.createElementNS(NS, "AnyFinderFieldRequest");
        doc.appendChild(root);
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://www.anyfinder.de/FieldRequest ../xml/AnyFinderFieldRequest.xsd");
        root.setAttribute("IndexName", fieldRequest.getIndexName());
        Iterator<DField> fields = fieldRequest.getFields();
        while (fields.hasNext()) {
            DField field = fields.next();
            DFieldCodec.encode(field, root);
        }
        return doc;
    }

    public static DAnyFinderFieldRequest decode(Element element) throws FieldRequestException {
        if (element == null) {
            throw new FieldRequestException("parameter must not be null [element]");
        }
        DAnyFinderFieldRequest fieldRequest = new DAnyFinderFieldRequest();
        fieldRequest.setIndexName(element.getAttribute("IndexName"));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element el;
            if (nl.item(i) instanceof Element && "Field".equals((el = (Element)nl.item(i)).getLocalName())) {
                fieldRequest.addField(DFieldCodec.decode(el));
            }
            ++i;
        }
        return fieldRequest;
    }
}

