/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.templates.messages.searchtemplates;

import org.eclipse.smila.search.plugin.Plugin;
import org.eclipse.smila.search.plugin.PluginFactory;
import org.eclipse.smila.search.templates.messages.searchtemplates.DSearchTemplatesException;
import org.eclipse.smila.search.templates.messages.searchtemplates.DSelectorCodec;
import org.eclipse.smila.search.templates.messages.searchtemplates.DTemplate;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

abstract class DTemplateCodec {
    private DTemplateCodec() {
    }

    protected static Element encode(DTemplate dTemplate, Element element) throws DSearchTemplatesException {
        Document doc = element.getOwnerDocument();
        Element el = (Element)element.appendChild(doc.createElementNS("http://www.anyfinder.de/SearchTemplates", "Template"));
        el.setAttribute("Name", dTemplate.getName());
        Element elTemp = null;
        elTemp = doc.createElementNS("http://www.anyfinder.de/SearchTemplates", "Description");
        elTemp.appendChild(doc.createTextNode(dTemplate.getDescription()));
        el.appendChild(elTemp);
        DSelectorCodec.encode(dTemplate.getSelector(), el);
        try {
            Plugin plugin = PluginFactory.getPlugin();
            plugin.getAdvSearchAccess().encode(dTemplate.getAdvSearch(), el);
        }
        catch (AdvSearchException e) {
            throw new DSearchTemplatesException(e.getMessage());
        }
        return el;
    }

    protected static DTemplate decode(Element element) throws DSearchTemplatesException {
        DTemplate dTemplate = new DTemplate();
        dTemplate.setName(element.getAttribute("Name"));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("Description".equals(nl.item(i).getLocalName())) {
                Element elTemp = (Element)nl.item(i);
                if (elTemp.hasChildNodes()) {
                    dTemplate.setDescription(((Text)elTemp.getFirstChild()).getNodeValue());
                } else {
                    dTemplate.setDescription("");
                }
            } else if ("Selector".equals(nl.item(i).getLocalName())) {
                dTemplate.setSelector(DSelectorCodec.decode((Element)nl.item(i)));
            } else if ("AnyFinderAdvancedSearch".equals(nl.item(i).getLocalName())) {
                try {
                    Element el = (Element)nl.item(i);
                    XMLUtils.removeWhitespaceTextNodes((Element)el);
                    Plugin plugin = PluginFactory.getPlugin();
                    dTemplate.setAdvSearch(plugin.getAdvSearchAccess().decode(el));
                }
                catch (Throwable e) {
                    throw new DSearchTemplatesException(e.getMessage());
                }
            }
            ++i;
        }
        return dTemplate;
    }
}

