/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;

public class SolrQueryParameterAccessor
extends QueryParameterAccessor {
    public SolrQueryParameterAccessor(Blackboard blackboard, String queryRecordId) throws BlackboardAccessException {
        super(blackboard, queryRecordId);
    }

    public SolrQueryParameterAccessor(Blackboard blackboard, AnyMap configuration, String queryRecordId) throws BlackboardAccessException {
        super(blackboard, configuration, queryRecordId);
    }

    public String getRequestHandler() {
        return this.getSolrQueryParams().getStringValue("qt");
    }

    public AnySeq getHighlighting() {
        return this.getSolrQueryParams().getSeq("highlighting");
    }

    public AnyMap getTerms() {
        return this.getSolrQueryParams().getMap("terms");
    }

    public AnySeq getFilterQuery() {
        return this.getSolrQueryParams().getSeq("fq");
    }

    public AnySeq getShards() {
        return this.getSolrQueryParams().getSeq("shards");
    }

    public AnyMap getSpellcheck() {
        return this.getSolrQueryParams().getMap("spellcheck");
    }

    public AnyMap getSolrQueryParams() {
        try {
            AnyMap _metadata = this._blackboard.getMetadata(this._recordId);
            AnyMap _solrQueryParams = _metadata.getMap("_solr.query");
            return _solrQueryParams == null ? AnyUtil.EMPTY_MAP : _solrQueryParams;
        }
        catch (BlackboardAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

