/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.DefinitionBase;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.WorkflowAction;
import org.eclipse.smila.jobmanager.internal.AccessAny;

public class WorkflowDefinition
extends DefinitionBase {
    public static final String KEY_WORKFLOWS = "workflows";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_VALUE = "value";
    public static final String KEY_START_ACTION = "startAction";
    public static final String KEY_ACTIONS = "actions";
    private final AnyMap _parameters;
    private final WorkflowAction _startAction;
    private final Collection<WorkflowAction> _actions;

    public WorkflowDefinition(AnyMap workflow) throws Exception {
        super(workflow);
        this._parameters = workflow.getMap(KEY_PARAMETERS);
        AnyMap startActionAny = (AnyMap)AccessAny.get(workflow, KEY_START_ACTION, Any.ValueType.MAP);
        if (startActionAny == null) {
            throw new InvalidConfigException("Workflow " + this._name + " does not define a startAction.");
        }
        this._startAction = new WorkflowAction(startActionAny);
        AnySeq actionsAny = (AnySeq)AccessAny.get(workflow, KEY_ACTIONS, Any.ValueType.SEQ);
        if (actionsAny != null) {
            this._actions = new ArrayList<WorkflowAction>();
            for (Any actionAny : actionsAny) {
                if (!actionAny.isMap()) continue;
                this._actions.add(new WorkflowAction((AnyMap)actionAny));
            }
        } else {
            this._actions = null;
        }
    }

    public static Collection<WorkflowDefinition> parseWorkflows(AnyMap workflowsAny, boolean setReadOnly) throws InvalidConfigException {
        ArrayList<WorkflowDefinition> workflows;
        block6: {
            workflows = new ArrayList<WorkflowDefinition>();
            try {
                if (workflowsAny.containsKey((Object)KEY_WORKFLOWS)) {
                    for (Any workflowAny : workflowsAny.getSeq(KEY_WORKFLOWS)) {
                        if (!workflowAny.isMap()) continue;
                        if (setReadOnly) {
                            workflowAny.asMap().put("readOnly", Boolean.valueOf(setReadOnly));
                        }
                        workflows.add(new WorkflowDefinition((AnyMap)workflowAny));
                    }
                    break block6;
                }
                throw new InvalidConfigException("Missing field workflows");
            }
            catch (InvalidConfigException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new InvalidConfigException("Invalid any structure", ex);
            }
        }
        return workflows;
    }

    public static WorkflowDefinition parseWorkflow(AnyMap workflowAny) throws InvalidConfigException {
        WorkflowDefinition workflow = null;
        try {
            workflow = new WorkflowDefinition(workflowAny);
        }
        catch (InvalidConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidConfigException("Invalid any structure", ex);
        }
        return workflow;
    }

    public AnyMap getParameters() {
        return this._parameters;
    }

    public WorkflowAction getStartAction() {
        return this._startAction;
    }

    public Collection<WorkflowAction> getActions() {
        return this._actions;
    }

    @Override
    public AnyMap toAny(boolean includingAdditionalAttributes) {
        try {
            AnyMap workflowAny = super.toAny(includingAdditionalAttributes);
            if (!includingAdditionalAttributes) {
                if (this._parameters != null) {
                    workflowAny.put(KEY_PARAMETERS, (Any)this._parameters);
                }
                if (this._startAction != null) {
                    workflowAny.put(KEY_START_ACTION, this._startAction.toAny());
                }
                if (this._actions != null) {
                    AnySeq actionsAny = DataFactory.DEFAULT.createAnySeq();
                    for (WorkflowAction action : this._actions) {
                        actionsAny.add((Object)action.toAny());
                    }
                    workflowAny.put(KEY_ACTIONS, (Any)actionsAny);
                }
            }
            return workflowAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for workflow " + this._name, ex);
        }
    }

    public Collection<String> getReferencedBuckets() {
        HashSet<String> result = new HashSet<String>();
        ArrayList<WorkflowAction> actions = new ArrayList<WorkflowAction>();
        if (this._startAction != null) {
            actions.add(this._startAction);
        }
        if (this._actions != null) {
            actions.addAll(this._actions);
        }
        for (WorkflowAction workflowAction : actions) {
            if (workflowAction.getInput() != null) {
                result.addAll(workflowAction.getInput().values());
            }
            if (workflowAction.getOutput() == null) continue;
            result.addAll(workflowAction.getOutput().values());
        }
        return result;
    }

    public Collection<String> getReferencedWorkers() {
        HashSet<String> result = new HashSet<String>();
        if (this._startAction != null) {
            result.add(this._startAction.getWorker());
        }
        if (this._actions != null) {
            for (WorkflowAction workflowAction : this._actions) {
                result.add(workflowAction.getWorker());
            }
        }
        return result;
    }
}

