/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.JobManagerException;
import org.eclipse.smila.taskmanager.Task;

public class InitialTaskHandler
extends JsonRequestHandler {
    private JobManager _jobManager;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String jobName;
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() != 2) {
            throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
        }
        String workerName = (String)uriParts.get(0);
        Task task = this._jobManager.getInitialTask(workerName, jobName = (String)uriParts.get(1));
        if (task != null) {
            return task.toAny();
        }
        return null;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException || ex instanceof InvalidValueTypeException) {
            return 400;
        }
        if (ex instanceof JobManagerException) {
            return ((JobManagerException)((Object)ex)).isRecoverable() ? 500 : 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected int getSuccessStatus(String requestMethod, String requestUri, Record inputRecord, Object resultObject) {
        if (resultObject == null) {
            return 204;
        }
        return super.getSuccessStatus(requestMethod, requestUri, inputRecord, resultObject);
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

