/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.IllegalJobStateException;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.JobDefinition;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.JobManagerException;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.JobRunMode;
import org.eclipse.smila.jobmanager.persistence.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.persistence.DefinitionPersistence;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.osgi.service.component.ComponentContext;

public class JobHandler
extends JsonRequestHandler {
    public static final String PARAM_RETURNRUNS = "returnRuns";
    public static final String KEY_DEFINITION = "definition";
    public static final String KEY_JOB_ID = "jobId";
    public static final String KEY_STATE = "state";
    public static final String KEY_URL = "url";
    public static final String KEY_CURRENT = "current";
    public static final String KEY_RUNS = "runs";
    public static final String KEY_HISTORY = "history";
    public static final String KEY_MODE = "mode";
    private JobManager _jobManager;
    private DefinitionPersistence _defPersistence;

    protected void activate(ComponentContext context) {
        super.activate(context);
        this._defPersistence = this._jobManager.getDefinitionPersistence();
    }

    protected void deactivate(ComponentContext context) {
        this._defPersistence = null;
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String jobName = this.getJobName(requestUri);
        if ("GET".equals(method)) {
            return this.getJobDefinition(requestUri, inputRecord, jobName);
        }
        if ("DELETE".equals(method)) {
            this._defPersistence.removeJob(jobName);
            return null;
        }
        if ("POST".equals(method)) {
            return this.startJob(requestUri, inputRecord, jobName);
        }
        return null;
    }

    private Object startJob(String requestUri, Record inputRecord, String jobName) throws JobManagerException, MalformedURLException {
        JobRunMode jobMode = this.getJobModeFromRecord(inputRecord);
        String jobId = this._jobManager.startJob(jobName, jobMode);
        AnyMap outputAny = FACTORY.createAnyMap();
        outputAny.put(KEY_JOB_ID, jobId);
        outputAny.put(KEY_URL, URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)jobId).toString());
        return outputAny;
    }

    private Object getJobDefinition(String requestUri, Record inputRecord, String jobName) throws JobManagerException, MalformedURLException {
        boolean returnDetails = this.getBooleanParameter(inputRecord, "returnDetails", false);
        boolean returnRuns = this.getBooleanParameter(inputRecord, PARAM_RETURNRUNS, true);
        AnyMap outputAny = FACTORY.createAnyMap();
        JobDefinition job = this._defPersistence.getJob(jobName);
        if (job == null) {
            throw new ConfigNotFoundException("Job '" + jobName + "' not found.");
        }
        outputAny.put(KEY_DEFINITION, (Any)job.toAny(returnDetails));
        if (returnRuns) {
            Collection<String> completedJobRuns;
            AnyMap runsAny = FACTORY.createAnyMap();
            outputAny.put(KEY_RUNS, (Any)runsAny);
            AnyMap currentAny = FACTORY.createAnyMap();
            runsAny.put(KEY_CURRENT, (Any)currentAny);
            JobRunInfo jobRunInfo = this._jobManager.getJobRunInfo(jobName);
            if (jobRunInfo != null) {
                String jobId = jobRunInfo.getId();
                currentAny.put(KEY_JOB_ID, jobId);
                currentAny.put(KEY_STATE, jobRunInfo.getState().toString());
                currentAny.put(KEY_URL, URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)jobId).toString());
            }
            if ((completedJobRuns = this._jobManager.getCompletedJobRunIds(jobName)) != null) {
                AnySeq historyAny = FACTORY.createAnySeq();
                for (String completedId : completedJobRuns) {
                    AnyMap singleAny = FACTORY.createAnyMap();
                    singleAny.put(KEY_JOB_ID, completedId);
                    singleAny.put(KEY_URL, URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)completedId).toString());
                    historyAny.add(0, (Any)singleAny);
                }
                runsAny.put(KEY_HISTORY, (Any)historyAny);
            }
        }
        return outputAny;
    }

    private boolean getBooleanParameter(Record parameters, String name, boolean defaultValue) {
        if (parameters != null && parameters.getMetadata().containsKey((Object)name)) {
            try {
                return parameters.getMetadata().getBooleanValue(name);
            }
            catch (InvalidValueTypeException invalidValueTypeException) {}
        }
        return defaultValue;
    }

    private JobRunMode getJobModeFromRecord(Record inputRecord) {
        if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)KEY_MODE)) {
            return JobRunMode.valueOf(inputRecord.getMetadata().getStringValue(KEY_MODE).toUpperCase(Locale.US));
        }
        return JobRunMode.STANDARD;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException || ex instanceof IllegalJobStateException || ex instanceof InvalidConfigException || ex instanceof JobManagerException && ex.getCause() instanceof TaskGeneratorException && ex.getCause().getCause() == null) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    private String getJobName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "DELETE".equals(method) || "POST".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

