/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.jobmanager.IllegalJobStateException;
import org.eclipse.smila.jobmanager.JobManager;

public class JobRunControlHandler
extends JsonRequestHandler {
    public static final String CMD_FINISH = "finish";
    public static final String CMD_CANCEL = "cancel";
    private static final int URIPARTS_COUNT = 3;
    private JobManager _jobManager;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() == 3) {
            String jobName = (String)uriParts.get(0);
            String jobId = (String)uriParts.get(1);
            String command = (String)uriParts.get(2);
            if (CMD_FINISH.equals(command)) {
                this._jobManager.finishJob(jobName, jobId);
            } else if (CMD_CANCEL.equals(command)) {
                this._jobManager.cancelJob(jobName, jobId);
            } else {
                throw new IllegalArgumentException("Invalid request URI, operation '" + command + "' not supported for job runs");
            }
            return null;
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'");
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        if (ex instanceof IllegalJobStateException) {
            return ((IllegalJobStateException)((Object)ex)).isJobRunGone() ? 410 : 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected int getSuccessStatus(String method, String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        String command = (String)uriParts.get(2);
        return CMD_FINISH.equals(command) ? 202 : 200;
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "POST".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

