/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.persistence.ConfigNotFoundException;

public class JobRunHandler
extends JsonRequestHandler {
    public static final String KEY_SHOW_DETAILS = "returnDetails";
    private JobManager _jobManager;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        if ("GET".equals(method)) {
            AnyMap outputAny;
            String jobName = this.getJobName(requestUri);
            boolean showDetails = false;
            if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)KEY_SHOW_DETAILS)) {
                showDetails = inputRecord.getMetadata().getBooleanValue(KEY_SHOW_DETAILS);
            }
            if ((outputAny = this._jobManager.getJobRunData(jobName, this.getJobId(requestUri), showDetails)) == null) {
                throw new ConfigNotFoundException("No such job run with name '" + jobName + "'.");
            }
            return outputAny;
        }
        if ("DELETE".equals(method)) {
            this._jobManager.deleteJobRunData(this.getJobName(requestUri), this.getJobId(requestUri));
        }
        return null;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected String getJobName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected String getJobId(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 1) {
            return (String)uriParts.get(1);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "DELETE".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

