/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.WorkerDefinition;
import org.eclipse.smila.jobmanager.persistence.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.persistence.DefinitionPersistence;
import org.eclipse.smila.jobmanager.persistence.PersistenceException;
import org.eclipse.smila.utils.http.NotFoundHTTPResult;
import org.osgi.service.component.ComponentContext;

public class WorkerHandler
extends JsonRequestHandler {
    private JobManager _jobManager;
    private DefinitionPersistence _defPersistence;

    protected void activate(ComponentContext context) {
        super.activate(context);
        this._defPersistence = this._jobManager.getDefinitionPersistence();
    }

    protected void deactivate(ComponentContext context) {
        this._defPersistence = null;
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        WorkerDefinition worker;
        String name = this.getName(requestUri);
        boolean returnDetails = false;
        if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)"returnDetails")) {
            returnDetails = inputRecord.getMetadata().getBooleanValue("returnDetails");
        }
        if ((worker = this._defPersistence.getWorker(name)) == null) {
            throw new ConfigNotFoundException("Worker '" + name + "' not found.");
        }
        return worker.toAny(returnDetails);
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof NotFoundHTTPResult) {
            return 404;
        }
        if (ex instanceof PersistenceException) {
            return 500;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    private String getName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

