/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.ipc.IpcSerializationUtils;
import org.eclipse.smila.jobmanager.BucketDefinition;
import org.eclipse.smila.jobmanager.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.IllegalJobStateException;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.JobDefinition;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.JobManagerException;
import org.eclipse.smila.jobmanager.WorkerDefinition;
import org.eclipse.smila.jobmanager.WorkflowDefinition;
import org.eclipse.smila.jobmanager.persistence.DefinitionAccessor;
import org.eclipse.smila.jobmanager.persistence.DefinitionStorage;
import org.eclipse.smila.jobmanager.persistence.DefinitionValidator;
import org.eclipse.smila.jobmanager.persistence.PersistenceException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.config.ConfigurationLoadException;

public class DefinitionPersistence {
    private static final String FILENAME_PREDEFINED_BUCKETS = "buckets.json";
    private static final String FILENAME_PREDEFINED_DATA_OBJECT_TYPES = "dataObjectTypes.json";
    private static final String FILENAME_PREDEFINED_WORKERS = "workers.json";
    private static final String FILENAME_PREDEFINED_WORKFLOWS = "workflows.json";
    private final DefinitionStorage _storage;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final IpcSerializationUtils _serializationUtils = new IpcSerializationUtils();
    private final DefinitionAccessor _definitionAccessor;
    private final DefinitionValidator _definitionValidator;

    public DefinitionPersistence(DefinitionStorage storage, JobManager jobManager, ObjectStoreService objectStoreService) {
        if (storage == null) {
            throw new IllegalArgumentException("DefinitionStorage must not be <null>.");
        }
        if (jobManager == null) {
            throw new IllegalArgumentException("JobManager must not be <null>.");
        }
        this._definitionAccessor = new DefinitionAccessor();
        this._definitionValidator = new DefinitionValidator(this._definitionAccessor, jobManager, objectStoreService);
        this.readConfiguredDataObjectTypeDefinitions();
        this.readConfiguredBucketDefinitions();
        this.readConfiguredWorkerDefinitions();
        this.readConfiguredWorkflowDefinitions();
        this._storage = storage;
        this._definitionAccessor.setStorage(storage);
    }

    public Collection<String> getDataObjectTypes() {
        return this._definitionAccessor.getDataObjectTypes();
    }

    public DataObjectTypeDefinition getDataObjectType(String name) {
        return this._definitionAccessor.getDataObjectType(name);
    }

    public Collection<String> getWorkers() {
        return this._definitionAccessor.getWorkers();
    }

    public WorkerDefinition getWorker(String name) {
        return this._definitionAccessor.getWorker(name);
    }

    public Collection<String> getBuckets() throws PersistenceException {
        return this._definitionAccessor.getBuckets();
    }

    public BucketDefinition getBucket(String name) throws PersistenceException {
        return this._definitionAccessor.getBucket(name);
    }

    public void addBucket(BucketDefinition bucketDefinition) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.validateBucket(bucketDefinition);
        this._definitionValidator.validateBucketWorkflows(bucketDefinition);
        this._storage.addBucket(bucketDefinition);
    }

    public void removeBucket(String name) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.checkRemoveBucket(name);
        this._storage.removeBucket(name);
    }

    public Collection<String> getJobs() throws PersistenceException {
        Collection<String> storageJobs;
        ArrayList<String> jobNames = new ArrayList<String>();
        if (this._storage != null && (storageJobs = this._storage.getJobs()) != null) {
            jobNames.addAll(storageJobs);
        }
        return jobNames;
    }

    public JobDefinition getJob(String name) throws PersistenceException {
        if (this._storage != null) {
            return this._storage.getJob(name);
        }
        return null;
    }

    public boolean hasJob(String jobName) throws PersistenceException {
        if (this._storage != null) {
            return this._storage.hasJob(jobName);
        }
        return false;
    }

    public void removeJob(String name) throws PersistenceException, IllegalJobStateException {
        try {
            this._definitionValidator.checkJobRemove(name);
        }
        catch (IllegalJobStateException e) {
            throw e;
        }
        catch (JobManagerException e) {
            throw new PersistenceException("Exception while checking job '" + name + "' for deletion.", (Throwable)((Object)e));
        }
        this._storage.removeJob(name);
    }

    public void addJob(JobDefinition jobDefinition) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.validateJob(jobDefinition);
        this._storage.addJob(jobDefinition);
    }

    public Collection<String> getWorkflows() throws PersistenceException {
        return this._definitionAccessor.getWorkflows();
    }

    public WorkflowDefinition getWorkflow(String name) throws PersistenceException {
        return this._definitionAccessor.getWorkflow(name);
    }

    public void removeWorkflow(String name) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.checkRemoveWorkflow(name);
        this._storage.removeWorkflow(name);
    }

    public void addWorkflow(WorkflowDefinition workflowDefinition) throws PersistenceException, InvalidConfigException {
        this._definitionValidator.validateWorkflow(workflowDefinition);
        this._storage.addWorkflow(workflowDefinition);
    }

    /*
     * Loose catch block
     */
    private void readConfiguredBucketDefinitions() {
        try {
            InputStream bucketsJson = ConfigUtils.getConfigStream((String)"org.eclipse.smila.jobmanager", (String)FILENAME_PREDEFINED_BUCKETS);
            try {
                try {
                    AnyMap bucketsAny = (AnyMap)this._serializationUtils.jsonStream2any(bucketsJson);
                    Collection<BucketDefinition> buckets = BucketDefinition.parseBuckets(bucketsAny, true);
                    HashMap<String, BucketDefinition> configuredBuckets = new HashMap<String, BucketDefinition>();
                    for (BucketDefinition bucket : buckets) {
                        if (configuredBuckets.containsKey(bucket.getName())) {
                            this._log.warn((Object)("Configuration contains duplicate bucket definition '" + bucket.getName() + "', ignoring second one."));
                            continue;
                        }
                        try {
                            this._definitionValidator.validateBucket(bucket);
                            configuredBuckets.put(bucket.getName(), bucket);
                        }
                        catch (InvalidConfigException ex) {
                            this._log.warn((Object)("Configuration contains invalid bucket definition for bucket '" + bucket.getName() + "'"), (Throwable)((Object)ex));
                        }
                    }
                    this._definitionAccessor.setConfiguredBuckets(configuredBuckets);
                }
                catch (IOException ex) {
                    this._log.warn((Object)"Error reading predefined buckets from configuration area, no predefined buckets available.", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)bucketsJson);
                }
                catch (PersistenceException ex) {
                    this._log.warn((Object)"Error reading predefined buckets from configuration area, no predefined buckets available.", (Throwable)((Object)ex));
                    IOUtils.closeQuietly((InputStream)bucketsJson);
                }
                catch (InvalidConfigException e) {
                    this._log.warn((Object)"Error parsing predefined bucket definitions from configuration area, no predefined bucket definitions available.", (Throwable)((Object)e));
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)bucketsJson);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)bucketsJson);
            }
        }
        catch (ConfigurationLoadException configurationLoadException) {
            this._log.info((Object)"No predefined buckets found in configuration area.");
        }
    }

    private void readConfiguredDataObjectTypeDefinitions() {
        try {
            InputStream dotJson = ConfigUtils.getConfigStream((String)"org.eclipse.smila.jobmanager", (String)FILENAME_PREDEFINED_DATA_OBJECT_TYPES);
            try {
                try {
                    AnyMap dotMap = (AnyMap)this._serializationUtils.jsonStream2any(dotJson);
                    Collection<DataObjectTypeDefinition> dots = DataObjectTypeDefinition.parseDataObjectTypeDefinitions(dotMap, true);
                    HashMap<String, DataObjectTypeDefinition> configuredDataObjectTypes = new HashMap<String, DataObjectTypeDefinition>();
                    for (DataObjectTypeDefinition dot : dots) {
                        configuredDataObjectTypes.put(dot.getName(), dot);
                    }
                    this._definitionAccessor.setConfiguredDataObjectTypes(configuredDataObjectTypes);
                }
                catch (IOException ex) {
                    this._log.warn((Object)"Error reading predefined data object type definitions from configuration area, no predefined data object type definitions available.", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)dotJson);
                }
                catch (InvalidConfigException e) {
                    this._log.warn((Object)"Error parsing predefined data object type definitions from configuration area, no predefined worker definitions available.", (Throwable)((Object)e));
                    IOUtils.closeQuietly((InputStream)dotJson);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)dotJson);
            }
        }
        catch (ConfigurationLoadException configurationLoadException) {
            this._log.info((Object)"No predefined data object types found in configuration area.");
        }
    }

    private void readConfiguredWorkerDefinitions() {
        try {
            InputStream workerJson = ConfigUtils.getConfigStream((String)"org.eclipse.smila.jobmanager", (String)FILENAME_PREDEFINED_WORKERS);
            try {
                try {
                    AnyMap workerMap = (AnyMap)this._serializationUtils.jsonStream2any(workerJson);
                    Collection<WorkerDefinition> workers = WorkerDefinition.parseWorkerDefinitions(workerMap, true);
                    HashMap<String, WorkerDefinition> configuredWorkers = new HashMap<String, WorkerDefinition>();
                    for (WorkerDefinition worker : workers) {
                        configuredWorkers.put(worker.getName(), worker);
                    }
                    this._definitionAccessor.setConfiguredWorkers(configuredWorkers);
                }
                catch (IOException ex) {
                    this._log.warn((Object)"Error reading predefined worker definitions from configuration area, no predefined worker definitions available.", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)workerJson);
                }
                catch (InvalidConfigException e) {
                    this._log.warn((Object)"Error parsing predefined worker definitions from configuration area, no predefined worker definitions available.", (Throwable)((Object)e));
                    IOUtils.closeQuietly((InputStream)workerJson);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)workerJson);
            }
        }
        catch (ConfigurationLoadException configurationLoadException) {
            this._log.info((Object)"No predefined workers found in configuration area.");
        }
    }

    private void readConfiguredWorkflowDefinitions() {
        try {
            InputStream workflowsJson = ConfigUtils.getConfigStream((String)"org.eclipse.smila.jobmanager", (String)FILENAME_PREDEFINED_WORKFLOWS);
            try {
                try {
                    AnyMap workflowsAnyMap = (AnyMap)this._serializationUtils.jsonStream2any(workflowsJson);
                    Collection<WorkflowDefinition> workflows = WorkflowDefinition.parseWorkflows(workflowsAnyMap, true);
                    HashMap<String, WorkflowDefinition> configuredWorkflows = new HashMap<String, WorkflowDefinition>();
                    for (WorkflowDefinition workflow : workflows) {
                        if (configuredWorkflows.containsKey(workflow.getName())) {
                            this._log.warn((Object)("Configuration contains duplicate workflow definition '" + workflow.getName() + "', ignoring second one."));
                            continue;
                        }
                        try {
                            this._definitionValidator.validateWorkflow(workflow);
                            configuredWorkflows.put(workflow.getName(), workflow);
                        }
                        catch (InvalidConfigException ex) {
                            this._log.warn((Object)("Configuration contains invalid workflow definition for workflow '" + workflow.getName() + "'."), (Throwable)((Object)ex));
                        }
                        catch (PersistenceException e) {
                            this._log.warn((Object)("Error while trying to validate workflow '" + workflow.getName() + "'."), (Throwable)((Object)e));
                        }
                    }
                    this._definitionAccessor.setConfiguredWorkflows(configuredWorkflows);
                }
                catch (IOException ex) {
                    this._log.warn((Object)"Error reading predefined workflows from configuration area, no predefined workflows available.", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)workflowsJson);
                }
                catch (InvalidConfigException e) {
                    this._log.warn((Object)"Error parsing predefined workflows from configuration area, no predefined workflows definitions available.", (Throwable)((Object)e));
                    IOUtils.closeQuietly((InputStream)workflowsJson);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)workflowsJson);
            }
        }
        catch (ConfigurationLoadException configurationLoadException) {
            this._log.info((Object)"No predefined workflows found in configuration area.");
        }
    }
}

