/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.jobmanager.Bucket;
import org.eclipse.smila.jobmanager.BucketDefinition;
import org.eclipse.smila.jobmanager.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.IllegalJobStateException;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.JobDefinition;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.JobManagerException;
import org.eclipse.smila.jobmanager.ParameterDefinition;
import org.eclipse.smila.jobmanager.WorkerDefinition;
import org.eclipse.smila.jobmanager.WorkflowAction;
import org.eclipse.smila.jobmanager.WorkflowDefinition;
import org.eclipse.smila.jobmanager.internal.AccessAny;
import org.eclipse.smila.jobmanager.persistence.DefinitionAccessor;
import org.eclipse.smila.jobmanager.persistence.PersistenceException;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.jobmanager.util.ExpressionUtil;
import org.eclipse.smila.jobmanager.util.ValueExpression;
import org.eclipse.smila.objectstore.ObjectStoreService;

public class DefinitionValidator {
    private static final String VARIABLE_SYSTEM_PREFIX = "_";
    private final Log _log = LogFactory.getLog(this.getClass());
    private final DefinitionAccessor _definitionAccessor;
    private final JobManager _jobManager;
    private final ObjectStoreService _objectStoreService;

    public DefinitionValidator(DefinitionAccessor definitionAccessor, JobManager jobManager, ObjectStoreService objectStoreService) {
        this._definitionAccessor = definitionAccessor;
        this._jobManager = jobManager;
        this._objectStoreService = objectStoreService;
    }

    public void validateJob(JobDefinition job) throws InvalidConfigException, PersistenceException {
        WorkflowDefinition workflow = this._definitionAccessor.getWorkflow(job.getWorkflow());
        if (workflow == null) {
            throw new InvalidConfigException("Workflow '" + job.getWorkflow() + "' of job '" + job.getName() + "' is not defined.");
        }
        this.validateJob(job, workflow, new HashMap<String, BucketDefinition>());
    }

    private void validateJob(JobDefinition job, WorkflowDefinition workflow, Map<String, BucketDefinition> bucketCache) throws InvalidConfigException, PersistenceException {
        Map<String, String> unresolvedParameters = this.getUnresolvedParameters(workflow, bucketCache);
        for (Map.Entry<String, String> unresolvedParameter : unresolvedParameters.entrySet()) {
            List<Any> matchingEntries = this.getMatchingParameterEntries(job.getParameters(), unresolvedParameter.getKey());
            if (matchingEntries != null && !matchingEntries.isEmpty()) continue;
            throw new InvalidConfigException("Parameter '" + unresolvedParameter.getKey() + "' (" + unresolvedParameter.getValue() + ") of workflow '" + job.getWorkflow() + "' is not resolved in job definition '" + job.getName() + "'.");
        }
        try {
            this.checkValidStoreNameForWorkflow(workflow, job.getParameters(), bucketCache);
        }
        catch (InvalidConfigException e) {
            Object cause = e;
            if (e != null && e.getCause() != null) {
                cause = e.getCause();
            }
            throw new InvalidConfigException("Parameters for job '" + job.getName() + "' and workflow '" + workflow.getName() + "' would result in invalid store name(s).", (Throwable)cause);
        }
        this.validateParameters(job, workflow);
    }

    public void validateWorkflow(WorkflowDefinition workflow) throws InvalidConfigException, PersistenceException {
        String workflowName = workflow.getName();
        if (this._definitionAccessor.getConfiguredWorkflows().containsKey(workflowName)) {
            throw new InvalidConfigException("Workflow '" + workflowName + "' cannot be added, because a preconfigured workflow definition with the same name already exists.");
        }
        this.validateWorkflow(workflow, new HashMap<String, BucketDefinition>());
    }

    private void validateWorkflow(WorkflowDefinition workflow, Map<String, BucketDefinition> bucketCache) throws InvalidConfigException, PersistenceException {
        String workflowName = workflow.getName();
        HashSet<String> existingNames = new HashSet<String>(this._definitionAccessor.getWorkflows());
        if (existingNames.contains(workflowName)) {
            Collection<JobDefinition> jobDefs = this.getJobsForWorkflow(workflowName);
            for (JobDefinition job : jobDefs) {
                this.validateJob(job, workflow, bucketCache);
            }
        }
        AnyMap workflowParameters = workflow.getParameters();
        for (String workerName : workflow.getReferencedWorkers()) {
            WorkerDefinition workerDefinition = this._definitionAccessor.getWorker(workerName);
            if (workerDefinition == null) {
                throw new InvalidConfigException("Referenced worker '" + workerName + "' of workflow '" + workflow.getName() + "' is not defined.");
            }
            this.validateWorkerParameterDefinition(workerDefinition, workflowParameters, false, workflowName, workerName);
        }
        this.checkWorkflowActionBuckets(workflow, bucketCache);
        this.checkValidStoreNameForWorkflow(workflow, null, bucketCache);
    }

    public void validateBucket(BucketDefinition bucketDefinition) throws InvalidConfigException, PersistenceException {
        String bucketName = bucketDefinition.getName();
        DataObjectTypeDefinition type = this._definitionAccessor.getDataObjectType(bucketDefinition.getDataObjectType());
        if (type == null) {
            throw new InvalidConfigException("DataObjectType '" + bucketDefinition.getDataObjectType() + "' of bucket '" + bucketName + "' is not defined.");
        }
        if (this._definitionAccessor.getConfiguredBuckets().containsKey(bucketName)) {
            throw new InvalidConfigException("Bucket '" + bucketName + "' cannot be added, because a preconfigured bucket definition with the same name already exists.");
        }
        this.checkValidStoreNameForBucket(bucketDefinition.getName(), bucketDefinition, type, null);
    }

    public void validateBucketWorkflows(BucketDefinition bucketDefinition) throws PersistenceException, InvalidConfigException {
        String bucketName = bucketDefinition.getName();
        HashMap<String, BucketDefinition> bucketCache = new HashMap<String, BucketDefinition>();
        bucketCache.put(bucketName, bucketDefinition);
        Collection<String> workflowNames = this._definitionAccessor.getWorkflows();
        for (String workflowName : workflowNames) {
            WorkflowDefinition workflow = this._definitionAccessor.getWorkflow(workflowName);
            if (workflow == null || !workflow.getReferencedBuckets().contains(bucketName)) continue;
            this.validateWorkflow(workflow, bucketCache);
        }
    }

    private void validateParameters(JobDefinition jobDefinition, WorkflowDefinition workflowDefinition) throws InvalidConfigException, PersistenceException {
        AnyMap jobAndWorkflowParameters = DataFactory.DEFAULT.createAnyMap();
        if (jobDefinition.getParameters() != null) {
            jobAndWorkflowParameters.putAll((Map)jobDefinition.getParameters());
        }
        if (workflowDefinition.getParameters() != null) {
            jobAndWorkflowParameters.putAll((Map)workflowDefinition.getParameters());
        }
        String workflowName = workflowDefinition.getName();
        this.validateActionParameters(workflowName, workflowDefinition.getStartAction(), jobAndWorkflowParameters);
        if (workflowDefinition.getActions() != null) {
            for (WorkflowAction action : workflowDefinition.getActions()) {
                this.validateActionParameters(workflowName, action, jobAndWorkflowParameters);
            }
        }
    }

    private void validateActionParameters(String workflowName, WorkflowAction workflowAction, AnyMap jobAndWorkflowParameters) throws InvalidConfigException {
        String workerName;
        WorkerDefinition workerDefinition;
        AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
        if (jobAndWorkflowParameters != null) {
            parameters.putAll((Map)jobAndWorkflowParameters);
        }
        if (workflowAction.getParameters() != null) {
            parameters.putAll((Map)workflowAction.getParameters());
        }
        if ((workerDefinition = this._definitionAccessor.getWorker(workerName = workflowAction.getWorker())) == null) {
            throw new InvalidConfigException("Unknown worker '" + workerName + "' used in workflow '" + workflowName + "'");
        }
        this.validateWorkerParameterDefinition(workerDefinition, parameters, true, workflowName, workerName);
        TaskGenerator taskGenerator = this._jobManager.getTaskGenerator(workerDefinition);
        String taskGeneratorName = taskGenerator.getName();
        try {
            taskGenerator.validateParameters(ExpressionUtil.evaluateParameters(parameters));
        }
        catch (TaskGeneratorException tge) {
            Object cause = tge;
            if (tge != null && tge.getCause() != null) {
                cause = tge.getCause();
            }
            throw new InvalidConfigException("Parameter validation failed for taskGenerator '" + taskGeneratorName + "' of worker '" + workerName + "' in workflow '" + workflowName + "'.", (Throwable)cause);
        }
    }

    private void validateWorkerParameterDefinition(WorkerDefinition workerDefinition, AnyMap parameters, boolean allParametersResolved, String workflowName, String workerName) throws InvalidConfigException {
        AnyMap evaluatedParameters = ExpressionUtil.evaluateParameters(parameters);
        if (workerDefinition.getParameters() != null) {
            if (evaluatedParameters != null) {
                for (ParameterDefinition paramDef : workerDefinition.getParameters()) {
                    List<Any> matchingEntries = this.getMatchingParameterEntries(evaluatedParameters, paramDef.getName());
                    if (matchingEntries != null) {
                        for (Any matchingParameter : matchingEntries) {
                            this.validateParameterDefinition(paramDef, matchingParameter, allParametersResolved, workflowName, workerName);
                        }
                        continue;
                    }
                    this.validateParameterDefinition(paramDef, null, allParametersResolved, workflowName, workerName);
                }
            } else if (allParametersResolved) {
                throw new InvalidConfigException("Parameters are missing for workflow '" + workflowName + "'.");
            }
        }
    }

    private void validateParameterDefinition(ParameterDefinition paramDef, Any parameter, boolean allParametersResolved, String workflowName, String workerName) throws InvalidConfigException {
        this.validateParameterUndefined(paramDef, parameter, allParametersResolved, workflowName, workerName);
        if (parameter == null) {
            return;
        }
        if (parameter.isString() && !allParametersResolved && new ValueExpression(parameter.asValue().asString()).referencesVariables()) {
            return;
        }
        if (paramDef.isMulti()) {
            for (Any param : parameter) {
                AnyMap clonedParam = DataFactory.DEFAULT.cloneAnyMap(paramDef.toAny());
                clonedParam.remove((Object)"multi");
                this.validateParameterDefinition(new ParameterDefinition(clonedParam), param, allParametersResolved, workflowName, workerName);
            }
        } else if (paramDef.getType() == Any.ValueType.MAP) {
            this.validateParameterDefinitionForMap(paramDef, parameter, allParametersResolved, workflowName, workerName);
        } else {
            this.validateParameterDefinitionForSimpleType(paramDef, parameter, workflowName, workerName);
        }
    }

    protected void validateParameterDefinitionForMap(ParameterDefinition paramDef, Any parameter, boolean allParametersResolved, String workflowName, String workerName) throws InvalidConfigException {
        if (parameter.isMap()) {
            for (ParameterDefinition entryParamDef : paramDef.getEntries()) {
                List<Any> matchingParameters = this.getMatchingParameterEntries(parameter.asMap(), entryParamDef.getName());
                if (matchingParameters != null && !matchingParameters.isEmpty()) {
                    for (Any matchingParameter : matchingParameters) {
                        this.validateParameterDefinition(entryParamDef, matchingParameter, allParametersResolved, workflowName, workerName);
                    }
                    continue;
                }
                if (entryParamDef.isOptional()) continue;
                throw new InvalidConfigException("Parameter '" + paramDef.getName() + "' of worker '" + workerName + "' in workflow '" + workflowName + "' is not defined.");
            }
        } else {
            throw new InvalidConfigException("Parameter '" + paramDef.getName() + "' of worker '" + workerName + "' in workflow '" + workflowName + "' is not of type MAP.");
        }
    }

    protected void validateParameterUndefined(ParameterDefinition paramDef, Any parameter, boolean allParametersResolved, String workflowName, String workerName) throws InvalidConfigException {
        if (parameter == null) {
            if (paramDef.isOptional() || !allParametersResolved) {
                return;
            }
            throw new InvalidConfigException("Parameter '" + paramDef.getName() + "' of worker '" + workerName + "' in workflow '" + workflowName + "' is missing.");
        }
    }

    private List<Any> getMatchingParameterEntries(AnyMap parameterMap, String name) {
        ArrayList<Any> matchingEntries = new ArrayList<Any>();
        if (parameterMap != null) {
            if (name.matches(".*<[^>]*>.*")) {
                String regex = name.replaceAll("<[^>]*>", ".*");
                for (Map.Entry entry : parameterMap.entrySet()) {
                    if (!((String)entry.getKey()).matches(regex)) continue;
                    matchingEntries.add((Any)entry.getValue());
                }
            } else {
                Any entry = (Any)parameterMap.get((Object)name);
                if (entry != null) {
                    matchingEntries.add(entry);
                }
            }
        }
        return matchingEntries;
    }

    protected void validateParameterDefinitionForSimpleType(ParameterDefinition paramDef, Any parameter, String workflowName, String workerName) throws InvalidConfigException {
        List<Value> possibleValues = paramDef.getValues();
        Any convertedValue = parameter;
        if (paramDef.getType() != null) {
            Any.ValueType type = paramDef.getType();
            try {
                switch (type) {
                    case BOOLEAN: {
                        convertedValue = DataFactory.DEFAULT.createBooleanValue(parameter.asValue().asBoolean());
                        break;
                    }
                    case DATE: {
                        convertedValue = DataFactory.DEFAULT.createDateValue(parameter.asValue().asDate());
                        break;
                    }
                    case DATETIME: {
                        convertedValue = DataFactory.DEFAULT.createDateTimeValue(parameter.asValue().asDateTime());
                        break;
                    }
                    case DOUBLE: {
                        convertedValue = DataFactory.DEFAULT.createDoubleValue(parameter.asValue().asDouble());
                        break;
                    }
                    case LONG: {
                        convertedValue = DataFactory.DEFAULT.createLongValue(parameter.asValue().asLong());
                        break;
                    }
                    case STRING: {
                        convertedValue = DataFactory.DEFAULT.createStringValue(parameter.asValue().asString());
                        break;
                    }
                    default: {
                        convertedValue = parameter.asValue();
                        break;
                    }
                }
            }
            catch (InvalidValueTypeException e) {
                throw new InvalidConfigException("Parameter '" + paramDef.getName() + "' of worker '" + workerName + "' in workflow '" + workflowName + "' is not of type '" + type + "' or could not be properly resolved.", e);
            }
        }
        if (possibleValues != null) {
            for (Value value : possibleValues) {
                if (!convertedValue.equals(DataFactory.DEFAULT.parseFromString(value.toString(), convertedValue.getValueType().name()))) continue;
                return;
            }
            throw new InvalidConfigException("Parameter '" + paramDef.getName() + "' of worker '" + workerName + "' in workflow '" + workflowName + "' is does not match allowed values '" + possibleValues + "'. Value was '" + parameter + "'.");
        }
    }

    private void checkValidStoreNameForWorkflow(WorkflowDefinition workflow, AnyMap parameters, Map<String, BucketDefinition> bucketCache) throws InvalidConfigException, PersistenceException {
        try {
            AnyMap workflowParameters = DataFactory.DEFAULT.createAnyMap();
            if (parameters != null) {
                workflowParameters.putAll((Map)parameters);
            }
            if (workflow.getParameters() != null) {
                workflowParameters.putAll((Map)workflow.getParameters());
            }
            for (WorkflowAction action : this.getAllActions(workflow)) {
                WorkerDefinition workerDefinition = this._definitionAccessor.getWorker(action.getWorker());
                this.checkStoreNamesForInAndOutputSlots(bucketCache, action, workflowParameters, workerDefinition);
            }
        }
        catch (InvalidConfigException e) {
            throw new InvalidConfigException("Parameters for workflow '" + workflow.getName() + "' would result in invalid store name(s).", (Throwable)((Object)e));
        }
    }

    private void checkStoreNamesForInAndOutputSlots(Map<String, BucketDefinition> bucketCache, WorkflowAction action, AnyMap workflowParameters, WorkerDefinition workerDefinition) throws PersistenceException, InvalidConfigException {
        String bucketName;
        if (action.getInput() != null && workerDefinition.getInput() != null) {
            for (WorkerDefinition.Input inputSlot : workerDefinition.getInput()) {
                bucketName = action.getInput().get(inputSlot.getName());
                if (bucketName == null) continue;
                this.checkStoreNameForActionSlot(bucketName, bucketCache, inputSlot, workflowParameters);
            }
        }
        if (action.getOutput() != null && workerDefinition != null && workerDefinition.getOutput() != null) {
            for (WorkerDefinition.Output outputSlot : workerDefinition.getOutput()) {
                bucketName = action.getOutput().get(outputSlot.getName());
                if (bucketName == null) continue;
                this.checkStoreNameForActionSlot(bucketName, bucketCache, outputSlot, workflowParameters);
            }
        }
    }

    private Collection<WorkflowAction> getAllActions(WorkflowDefinition workflow) {
        ArrayList<WorkflowAction> actions = new ArrayList<WorkflowAction>();
        if (workflow.getStartAction() != null) {
            actions.add(workflow.getStartAction());
        }
        if (workflow.getActions() != null) {
            actions.addAll(workflow.getActions());
        }
        return actions;
    }

    private void checkStoreNameForActionSlot(String bucketName, Map<String, BucketDefinition> bucketCache, WorkerDefinition.InputOutput<?> slot, AnyMap workflowParameters) throws PersistenceException, InvalidConfigException {
        BucketDefinition bucketDef;
        if (bucketCache.containsKey(bucketName)) {
            bucketDef = bucketCache.get(bucketName);
        } else {
            bucketDef = this._definitionAccessor.getBucket(bucketName);
            bucketCache.put(bucketName, bucketDef);
        }
        DataObjectTypeDefinition dot = this._definitionAccessor.getDataObjectType(slot.getType());
        this.checkValidStoreNameForBucket(bucketName, bucketDef, dot, workflowParameters);
    }

    private Map<String, String> getUnresolvedParameters(WorkflowDefinition workflow, Map<String, BucketDefinition> bucketCache) throws PersistenceException {
        Map<String, String> unresolvedParams = new LinkedHashMap<String, String>();
        if (workflow != null) {
            Collection<WorkflowAction> actions = this.getAllActions(workflow);
            for (WorkflowAction action : actions) {
                unresolvedParams.putAll(this.getUnresolvedActionParameters(action, bucketCache));
            }
            if (workflow.getParameters() != null) {
                this.fillUnresolvedVariables((Any)workflow.getParameters(), null, "workflow", unresolvedParams);
                unresolvedParams = this.removeDefinedVariables(workflow.getParameters(), unresolvedParams);
            }
        }
        this.removeSystemParameters(unresolvedParams);
        return unresolvedParams;
    }

    protected Map<String, String> removeDefinedVariables(AnyMap topLevelParameters, Map<String, String> unresolvedParams) {
        HashMap<String, String> returnMap = new HashMap<String, String>(unresolvedParams);
        for (Map.Entry entry : topLevelParameters.entrySet()) {
            if (entry.getValue() == null || !((Any)entry.getValue()).isValue()) continue;
            returnMap.remove(entry.getKey());
        }
        return returnMap;
    }

    protected void fillUnresolvedVariables(Any parameter, String key, String container, Map<String, String> variableReferencingParameters) {
        block4: {
            block5: {
                block3: {
                    if (!parameter.isSeq()) break block3;
                    for (Any singleParam : parameter.asSeq()) {
                        this.fillUnresolvedVariables(singleParam, key, container, variableReferencingParameters);
                    }
                    break block4;
                }
                if (!parameter.isMap()) break block5;
                for (Map.Entry entry : parameter.asMap().entrySet()) {
                    String newKey = key != null ? String.valueOf(key) + "/" + (String)entry.getKey() : (String)entry.getKey();
                    this.fillUnresolvedVariables((Any)entry.getValue(), newKey, container, variableReferencingParameters);
                }
                break block4;
            }
            if (!parameter.isString()) break block4;
            ValueExpression ve = new ValueExpression(parameter.asValue().asString());
            for (String variable : ve.getVariables()) {
                variableReferencingParameters.put(variable, "variable in '" + container + "' of parameter '" + key + "'");
            }
        }
    }

    private void removeSystemParameters(Map<String, String> params) {
        Iterator<String> iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String varName = iter.next();
            if (!varName.startsWith(VARIABLE_SYSTEM_PREFIX)) continue;
            iter.remove();
        }
    }

    private Map<String, String> getUnresolvedActionParameters(WorkflowAction action, Map<String, BucketDefinition> bucketCache) throws PersistenceException {
        HashMap<String, String> unresolvedWorkerParams = new HashMap<String, String>();
        WorkerDefinition workerDefinition = this._definitionAccessor.getWorker(action.getWorker());
        if (workerDefinition != null && workerDefinition.getMandatoryParameterNames() != null) {
            for (String parameter : workerDefinition.getMandatoryParameterNames()) {
                unresolvedWorkerParams.put(parameter, "parameter of worker '" + workerDefinition.getName() + "'");
            }
        }
        if (action.getParameters() != null) {
            for (Map.Entry entry : action.getParameters().entrySet()) {
                unresolvedWorkerParams.remove(entry.getKey());
                this.fillUnresolvedVariables((Any)entry.getValue(), (String)entry.getKey(), "worker action '" + action.getWorker() + "'", unresolvedWorkerParams);
            }
        }
        unresolvedWorkerParams.putAll(this.getUnresolvedParametersForActionSlots(action, bucketCache, workerDefinition));
        return unresolvedWorkerParams;
    }

    private Map<String, String> getUnresolvedParametersForActionSlots(WorkflowAction action, Map<String, BucketDefinition> bucketCache, WorkerDefinition workerDefinition) throws PersistenceException {
        String bucketName;
        HashMap<String, String> unresolvedActionSlotParams = new HashMap<String, String>();
        if (workerDefinition != null && workerDefinition.getInput() != null) {
            for (WorkerDefinition.Input inputSlot : workerDefinition.getInput()) {
                bucketName = action.getInput().get(inputSlot.getName());
                unresolvedActionSlotParams.putAll(this.getUnresolvedParametersForBucket(bucketName, bucketCache, inputSlot));
            }
        }
        if (workerDefinition != null && workerDefinition.getOutput() != null && action.getOutput() != null) {
            for (WorkerDefinition.Output outputSlot : workerDefinition.getOutput()) {
                bucketName = action.getOutput().get(outputSlot.getName());
                unresolvedActionSlotParams.putAll(this.getUnresolvedParametersForBucket(bucketName, bucketCache, outputSlot));
            }
        }
        return unresolvedActionSlotParams;
    }

    private Map<String, String> getUnresolvedParametersForBucket(String bucketName, Map<String, BucketDefinition> bucketCache, WorkerDefinition.InputOutput<?> slot) throws PersistenceException {
        Map<String, String> unresolvedBucketParams = new HashMap<String, String>();
        if (bucketName != null) {
            BucketDefinition bucketDef;
            if (bucketCache.containsKey(bucketName)) {
                bucketDef = bucketCache.get(bucketName);
            } else {
                bucketDef = this._definitionAccessor.getBucket(bucketName);
                bucketCache.put(bucketName, bucketDef);
            }
            boolean isPersistent = bucketDef != null;
            Collection<String> dataObjectTypeVariables = this.getDataObjectTypeVariables(slot.getType(), isPersistent);
            for (String dataObjectTypeVar : dataObjectTypeVariables) {
                unresolvedBucketParams.put(dataObjectTypeVar, "variable for dataObjectType '" + slot.getType() + "' of bucket '" + bucketName + "' used in slot '" + slot.getName() + "'");
            }
            if (bucketDef != null && bucketDef.getParameters() != null) {
                this.fillUnresolvedVariables((Any)bucketDef.getParameters(), null, "bucket '" + bucketName + "' used in slot '" + slot.getName() + "'", unresolvedBucketParams);
                unresolvedBucketParams = this.removeDefinedVariables(bucketDef.getParameters(), unresolvedBucketParams);
            }
        }
        return unresolvedBucketParams;
    }

    private Collection<String> getDataObjectTypeVariables(String typeName, boolean isPersistent) {
        HashSet<String> variables = new HashSet<String>();
        DataObjectTypeDefinition dto = this._definitionAccessor.getDataObjectType(typeName);
        if (dto != null) {
            if (isPersistent && dto.hasPersistentMode()) {
                variables.addAll(dto.getObject(DataObjectTypeDefinition.Mode.PERSISTENT).getVariables());
                variables.addAll(dto.getStore(DataObjectTypeDefinition.Mode.PERSISTENT).getVariables());
            }
            if (!isPersistent && dto.hasTransientMode()) {
                variables.addAll(dto.getObject(DataObjectTypeDefinition.Mode.TRANSIENT).getVariables());
                variables.addAll(dto.getStore(DataObjectTypeDefinition.Mode.TRANSIENT).getVariables());
            }
        }
        return variables;
    }

    private Collection<JobDefinition> getJobsForWorkflow(String workflowName) throws PersistenceException {
        ArrayList<JobDefinition> jobs = new ArrayList<JobDefinition>();
        Collection<String> storageJobs = this._definitionAccessor.getJobs();
        for (String jobName : storageJobs) {
            JobDefinition jobDef = this._definitionAccessor.getJob(jobName);
            if (!jobDef.getWorkflow().equals(workflowName)) continue;
            jobs.add(jobDef);
        }
        return jobs;
    }

    private void checkWorkflowActionBuckets(WorkflowDefinition workflow, Map<String, BucketDefinition> bucketCache) throws InvalidConfigException, PersistenceException {
        HashSet<WorkflowAction> actions = new HashSet<WorkflowAction>();
        if (workflow.getActions() != null) {
            actions.addAll(workflow.getActions());
        }
        if (workflow.getStartAction() != null) {
            WorkflowAction startAction = workflow.getStartAction();
            actions.add(startAction);
            this.checkWorkflowStartAction(workflow.getName(), startAction, bucketCache);
        }
        for (WorkflowAction workflowAction : actions) {
            WorkerDefinition workerDefinition = this._definitionAccessor.getWorker(workflowAction.getWorker());
            if (workerDefinition == null) {
                throw new InvalidConfigException("An action of workflow '" + workflow.getName() + "' references a worker '" + workflowAction.getWorker() + "' that is not defined.");
            }
            Map<String, String> inputFromAction = workflowAction.getInput();
            this.checkWorkflowActionInputs(workflow.getName(), inputFromAction, workerDefinition, bucketCache);
            if (workerDefinition.getOutput() == null) continue;
            String actionSlotGroup = null;
            Map<String, String> outputFromAction = workflowAction.getOutput();
            if (outputFromAction != null) {
                for (WorkerDefinition.Output outputFromWorkerDef : workerDefinition.getOutput()) {
                    if (!outputFromAction.keySet().contains(outputFromWorkerDef.getName())) continue;
                    actionSlotGroup = this.checkSlotGroup(workflow, workflowAction, actionSlotGroup, outputFromWorkerDef);
                }
            }
            if (actionSlotGroup == null && workerDefinition.hasOnlyMandatoryGroups()) {
                throw new InvalidConfigException("Each output group of worker '" + workerDefinition.getName() + "' contains a mandatory slot, so one group must be used in workflow '" + workflow.getName() + "'");
            }
            this.checkWorkflowActionOutputs(workflow.getName(), outputFromAction, workerDefinition, actionSlotGroup, bucketCache);
        }
    }

    private String checkSlotGroup(WorkflowDefinition workflow, WorkflowAction workflowAction, String actionSlotGroup, WorkerDefinition.Output slotFromWorkerDef) throws InvalidConfigException {
        String slotGroup = slotFromWorkerDef.getGroup();
        if (actionSlotGroup == null) {
            actionSlotGroup = slotGroup;
        } else if (slotGroup != null && !actionSlotGroup.equals(slotGroup)) {
            throw new InvalidConfigException("An action of workflow '" + workflow.getName() + "' mixes two slot groups '" + actionSlotGroup + "' and '" + slotGroup + "' for worker '" + workflowAction.getWorker() + "'.");
        }
        return actionSlotGroup;
    }

    private void checkWorkflowStartAction(String workflow, WorkflowAction startAction, Map<String, BucketDefinition> bucketCache) throws InvalidConfigException, PersistenceException {
        Map<String, String> startActionInputMap = startAction.getInput();
        if (startActionInputMap != null) {
            for (String inputBucket : startActionInputMap.values()) {
                BucketDefinition bucketDefinition = bucketCache.get(inputBucket);
                if (bucketDefinition == null) {
                    bucketDefinition = this._definitionAccessor.getBucket(inputBucket);
                    bucketCache.put(inputBucket, bucketDefinition);
                }
                if (bucketDefinition != null) continue;
                throw new InvalidConfigException("Start action worker of workflow '" + workflow + "' references an input bucket '" + inputBucket + "' that is not defined. (Start action input buckets must be persistent!)");
            }
        }
    }

    private void checkWorkflowActionInputs(String workflow, Map<String, String> inputFromAction, WorkerDefinition workerDefinition, Map<String, BucketDefinition> bucketCache) throws InvalidConfigException {
        if (workerDefinition.getInput() != null) {
            for (WorkerDefinition.Input inputFromWorkerDef : workerDefinition.getInput()) {
                if (inputFromAction == null || !inputFromAction.keySet().contains(inputFromWorkerDef.getName())) {
                    throw new InvalidConfigException("Input slot '" + inputFromWorkerDef.getName() + "' of referenced worker '" + workerDefinition.getName() + "' of workflow '" + workflow + "' is not defined in workflow action.");
                }
                if (!this.checkBucketType(inputFromAction.get(inputFromWorkerDef.getName()), inputFromWorkerDef.getType(), bucketCache)) {
                    throw new InvalidConfigException("Input bucket '" + inputFromAction.get(inputFromWorkerDef.getName()) + "' for referenced worker '" + workerDefinition.getName() + "' of workflow '" + workflow + "' has the wrong type.");
                }
                if (this.checkBucketMode(inputFromAction.get(inputFromWorkerDef.getName()), inputFromWorkerDef.getType(), bucketCache)) continue;
                throw new InvalidConfigException("Input bucket '" + inputFromAction.get(inputFromWorkerDef.getName()) + "' for referenced worker '" + workerDefinition.getName() + "' of workflow '" + workflow + "' is not defined, but has no transient mode.");
            }
        }
    }

    private void checkWorkflowActionOutputs(String workflow, Map<String, String> outputFromAction, WorkerDefinition workerDefinition, String activeSlotGroup, Map<String, BucketDefinition> bucketCache) throws InvalidConfigException {
        for (WorkerDefinition.Output outputFromWorkerDef : workerDefinition.getOutput()) {
            if (outputFromAction == null || !outputFromAction.keySet().contains(outputFromWorkerDef.getName())) {
                if (!outputFromWorkerDef.getModes().contains((Object)WorkerDefinition.OutputMode.OPTIONAL)) {
                    if (outputFromWorkerDef.getGroup() == null || outputFromWorkerDef.getGroup().equals(activeSlotGroup)) {
                        throw new InvalidConfigException("Output slot '" + outputFromWorkerDef.getName() + "' of referenced worker '" + workerDefinition.getName() + "' of workflow '" + workflow + "' is not defined.");
                    }
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug((Object)("Mandatory output bucket '" + outputFromWorkerDef.getName() + "' of worker '" + workerDefinition.getName() + "' is not defined in workflow '" + workflow + "' but a different slot group is active."));
                    continue;
                }
                if (!this._log.isDebugEnabled()) continue;
                this._log.debug((Object)("Optional output bucket '" + outputFromWorkerDef.getName() + "' of worker '" + workerDefinition.getName() + "' is not defined in workflow '" + workflow + "'."));
                continue;
            }
            if (!this.checkBucketType(outputFromAction.get(outputFromWorkerDef.getName()), outputFromWorkerDef.getType(), bucketCache)) {
                throw new InvalidConfigException("Output bucket '" + outputFromAction.get(outputFromWorkerDef.getName()) + "' for referenced worker '" + workerDefinition.getName() + "' of workflow '" + workflow + "' has the wrong type.");
            }
            if (this.checkBucketMode(outputFromAction.get(outputFromWorkerDef.getName()), outputFromWorkerDef.getType(), bucketCache)) continue;
            throw new InvalidConfigException("Output bucket '" + outputFromAction.get(outputFromWorkerDef.getName()) + "' for referenced worker '" + workerDefinition.getName() + "' of workflow '" + workflow + "' is persistent, so it has to be defined.");
        }
    }

    private boolean checkBucketType(String bucketName, String type, Map<String, BucketDefinition> bucketCache) {
        BucketDefinition bucketDefinition;
        block6: {
            try {
                bucketDefinition = bucketCache.get(bucketName);
                if (bucketDefinition == null) {
                    bucketDefinition = this._definitionAccessor.getBucket(bucketName);
                    bucketCache.put(bucketName, bucketDefinition);
                }
                if (bucketDefinition != null) break block6;
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Bucket '" + bucketName + "' does not exist, so it is assumed this bucket is transient."));
                }
                return true;
            }
            catch (Exception e) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)("An error occurred while trying to check bucket '" + bucketName + "' for type '" + type + "'."), (Throwable)e);
                }
                return false;
            }
        }
        return bucketDefinition.getDataObjectType().equals(type);
    }

    private boolean checkBucketMode(String bucketName, String type, Map<String, BucketDefinition> bucketCache) {
        try {
            BucketDefinition bucketDefinition = bucketCache.get(bucketName);
            if (bucketDefinition == null) {
                bucketDefinition = this._definitionAccessor.getBucket(bucketName);
                bucketCache.put(bucketName, bucketDefinition);
            }
            if (bucketDefinition == null) {
                DataObjectTypeDefinition dot = this._definitionAccessor.getDataObjectType(type);
                return dot.hasTransientMode();
            }
            return true;
        }
        catch (Exception e) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("An error occurred while trying to check bucket '" + bucketName + "' for type '" + type + "'."), (Throwable)e);
            }
            return false;
        }
    }

    private boolean checkValidStoreNameForBucket(String bucketName, BucketDefinition bucketDefinition, DataObjectTypeDefinition type, AnyMap externalParameters) throws InvalidConfigException {
        AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
        if (externalParameters != null) {
            parameters.putAll((Map)externalParameters);
        }
        if (bucketDefinition != null && bucketDefinition.getParameters() != null) {
            parameters.putAll((Map)bucketDefinition.getParameters());
        }
        if (parameters.size() > 0) {
            BucketDefinition bDef;
            if (bucketDefinition == null) {
                AnyMap bucketAny = AccessAny.FACTORY.createAnyMap();
                try {
                    bucketAny.put("name", bucketName);
                    bucketAny.put("type", type.getName());
                }
                catch (Exception e) {
                    this._log.error((Object)"Error while trying to create temporary bucket definition.", (Throwable)e);
                    return false;
                }
                bDef = new BucketDefinition(bucketAny);
            } else {
                bDef = bucketDefinition;
            }
            Bucket bucket = new Bucket(bDef, type, bucketDefinition != null, parameters);
            String resolvedStoreNameWithoutUnresolvedVariables = bucket.getStoreName().replaceAll("\\$\\{([^\\$\\{\\s]+?)\\}", "");
            if (resolvedStoreNameWithoutUnresolvedVariables.length() > 0 && !this._objectStoreService.isValidStoreName(resolvedStoreNameWithoutUnresolvedVariables)) {
                throw new InvalidConfigException("Current parameters would result in invalid store name '" + resolvedStoreNameWithoutUnresolvedVariables + "' for DataObjectType '" + type.getName() + "' of bucket '" + bDef.getName() + "'.");
            }
        }
        return true;
    }

    public void checkRemoveWorkflow(String name) throws InvalidConfigException, PersistenceException {
        if (this._definitionAccessor.getConfiguredWorkflows().containsKey(name)) {
            throw new IllegalArgumentException("Workflow '" + name + "' cannot be removed, because it is predefined by configuration");
        }
        Collection<String> jobNames = this._definitionAccessor.getJobs();
        for (String jobName : jobNames) {
            JobDefinition job = this._definitionAccessor.getJob(jobName);
            if (job == null || !name.equals(job.getWorkflow())) continue;
            throw new InvalidConfigException("Workflow '" + name + "' cannot be deleted. It is still referenced by job '" + job.getName() + "'.");
        }
    }

    public void checkRemoveBucket(String name) throws InvalidConfigException, PersistenceException {
        if (this._definitionAccessor.getConfiguredBuckets().containsKey(name)) {
            throw new IllegalArgumentException("Bucket '" + name + "' cannot be removed, because it is predefined by configuration");
        }
        Collection<String> workflowNames = this._definitionAccessor.getWorkflows();
        for (String workflowName : workflowNames) {
            WorkflowDefinition workflow = this._definitionAccessor.getWorkflow(workflowName);
            if (workflow == null || !workflow.getReferencedBuckets().contains(name)) continue;
            throw new InvalidConfigException("Bucket '" + name + "' cannot be deleted. It is still referenced by workflow '" + workflow.getName() + "'.");
        }
    }

    public void checkJobRemove(String jobName) throws JobManagerException {
        if (this._jobManager.getJobRunInfo(jobName) != null) {
            throw new IllegalJobStateException("Job '" + jobName + "' cannot be removed, it is still running.");
        }
    }
}

