/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.util;

import java.util.HashMap;
import java.util.Map;

public final class DataSizeParser {
    private static final Map<Character, Long> SUFFIX_FACTOR = new HashMap<Character, Long>();
    private static final char[] SUFFIX = new char[]{'b', 'k', 'm', 'g', 't', 'p'};
    private static final long FACTOR = 10L;

    static {
        long factor = 1L;
        char[] cArray = SUFFIX;
        int n = SUFFIX.length;
        int n2 = 0;
        while (n2 < n) {
            Character suffix = Character.valueOf(cArray[n2]);
            SUFFIX_FACTOR.put(suffix, factor);
            factor <<= 10;
            ++n2;
        }
    }

    private DataSizeParser() throws InstantiationException {
        throw new InstantiationException("utility class only.");
    }

    public static long parse(String dataSize, long defaultSize) {
        if (dataSize == null) {
            return defaultSize;
        }
        int length = dataSize.length();
        if (length == 0) {
            return defaultSize;
        }
        char lastChar = dataSize.charAt(length - 1);
        if (lastChar >= '0' && lastChar <= '9') {
            return Long.parseLong(dataSize);
        }
        Character suffix = Character.valueOf(Character.toLowerCase(lastChar));
        if (!SUFFIX_FACTOR.containsKey(suffix)) {
            throw new IllegalArgumentException("Unknown magnitude character '" + lastChar + "'");
        }
        String numberPart = dataSize.substring(0, length - 1);
        try {
            long number = Long.parseLong(numberPart);
            return number * SUFFIX_FACTOR.get(suffix);
        }
        catch (NumberFormatException numberFormatException) {
            double number = Double.parseDouble(numberPart);
            return (long)(number * (double)SUFFIX_FACTOR.get(suffix).longValue());
        }
    }

    public static long parse(String dataSize) {
        return DataSizeParser.parse(dataSize, 0L);
    }
}

