/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.worker;

import java.util.List;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.JobManagerException;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.taskworker.RecoverableTaskException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;

public class FinishTaskWorker
implements Worker {
    private static final String WORKER_NAME = "_finishingTasks";
    private JobManager _jobManager;
    private TaskManager _taskManager;

    public String getName() {
        return WORKER_NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        try {
            List<Task> newTasks = this.finishTask(taskContext);
            this.countNewTasks(taskContext, newTasks);
        }
        catch (JobManagerException ex) {
            if (ex.isRecoverable()) {
                throw new RecoverableTaskException(ex.getMessage(), (Throwable)((Object)ex));
            }
            throw ex;
        }
    }

    private List<Task> finishTask(TaskContext taskContext) throws JobManagerException {
        taskContext.addToCounter("finishedTaskCount", 1L);
        long start = taskContext.getTimestamp();
        try {
            List<Task> list = this._jobManager.finishTask(taskContext.getTask());
            return list;
        }
        finally {
            taskContext.measureTime("finishTask", start);
        }
    }

    private void countNewTasks(TaskContext taskContext, List<Task> newTasks) throws TaskmanagerException {
        if (newTasks != null && !newTasks.isEmpty()) {
            taskContext.addToCounter("newTaskCount", (long)newTasks.size());
        }
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (taskManager == this._taskManager) {
            this._taskManager = null;
        }
    }
}

