/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskmanager;

/**
 * BadParameterTaskmanagerException class.
 */
public class BadParameterTaskmanagerException extends TaskmanagerException {
  /**
   * exceptions are serializable.
   */
  private static final long serialVersionUID = 1L;

  /**
   * enum defining the causes.
   */
  public enum Cause {
    /** invalid worker name. */
    workerName,
    /** invalid task id. */
    taskId,
    /** invalid operation. */
    operation;
  }

  /**
   * the cause of the exception.
   */
  private final Cause _cause;

  /**
   * @param message
   *          a message
   * @param code
   *          a cause
   */
  public BadParameterTaskmanagerException(final String message, final Cause code) {
    super(message);
    _cause = code;
  }

  /**
   * @param message
   *          a message
   * @param code
   *          a cause
   * @param e
   *          the causing exception
   */
  public BadParameterTaskmanagerException(final String message, final Cause code, final Exception e) {
    super(message, e);
    _cause = code;
  }

  /**
   * @return the cause
   */
  public Cause getCauseCode() {
    return _cause;
  }
}
