/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager;

/**
 * constants used in JobManager data, e.g. keys of job run data properties.
 */
public final class JobManagerConstants {

  /** bundle name holding configuration data. */
  public static final String CONFIGURATION_BUNDLE = "org.eclipse.smila.jobmanager";

  /** base request URI for all jobmanager parts. */
  public static final String JOBMANAGER_REQUEST_URI = "/smila/jobmanager/";

  /** job run data key name for job run id. */
  public static final String DATA_JOB_ID = "jobId";

  /** job run data key name for job state. */
  public static final String DATA_JOB_STATE = "state";

  /** job run data node for grouping workflow run counter. */
  public static final String WORKFLOW_RUN_COUNTER = "workflowRuns";

  /** job run data node for grouping task counter. */
  public static final String TASK_COUNTER = "tasks";

  /** job run data key name for number of active workflow runs. */
  public static final String DATA_JOB_NO_OF_ACTIVE_WORKFLOW_RUNS = "activeWorkflowRunCount";

  /** job run data key name for number of successfully finished workflow runs. */
  public static final String DATA_JOB_NO_OF_SUCCESSFUL_WORKFLOW_RUNS = "successfulWorkflowRunCount";

  /** job run data key name for number of failed workflow runs. */
  public static final String DATA_JOB_NO_OF_FAILED_WORKFLOW_RUNS = "failedWorkflowRunCount";

  /** job data key name for number of started workflow runs. */
  public static final String DATA_JOB_NO_OF_STARTED_WORKFLOW_RUNS = "startedWorkflowRunCount";

  /** job data key name for number of canceled workflow runs. */
  public static final String DATA_JOB_NO_OF_CANCELED_WORKFLOW_RUNS = "canceledWorkflowRunCount";

  /** job run data key name for number of created tasks. */
  public static final String DATA_JOB_NO_OF_CREATED_TASKS = "createdTaskCount";

  /** job data key name for number of successfully finished tasks. */
  public static final String DATA_JOB_NO_OF_SUCCESSFUL_TASKS = "successfulTaskCount";

  /** job data key name for number of obsolete tasks. */
  public static final String DATA_JOB_NO_OF_OBSOLETE_TASKS = "obsoleteTaskCount";

  /** job data key name for number of (finally) failed tasks that had been retried. */
  public static final String DATA_JOB_NO_OF_FAILED_TASKS_RETRIED = "failedAfterRetryTaskCount";

  /** job data key name for number of failed tasks that have not been retried. */
  public static final String DATA_JOB_NO_OF_FAILED_TASKS_NOT_RETRIED = "failedWithoutRetryTaskCount";

  /** job data key name for number of retried tasks, that were retried because of missing keep-alive. */
  public static final String DATA_JOB_NO_OF_RETRIED_TASKS_TTL = "retriedAfterTimeoutTaskCount";

  /** job data key name for number of retried tasks, that were retried because of worker result. */
  public static final String DATA_JOB_NO_OF_RETRIED_TASKS_WORKER = "retriedAfterErrorTaskCount";

  /** job data key name for number of cancelled tasks. */
  public static final String DATA_JOB_NO_OF_CANCELLED_TASKS = "canceledTaskCount";

  /** job run data key name for job run start time. */
  public static final String DATA_JOB_RUN_START_TIME = "startTime";

  /** job run data key name for job run finish time. */
  public static final String DATA_JOB_RUN_FINISH_TIME = "finishTime";

  /** job run data key name for job run end time. */
  public static final String DATA_JOB_RUN_END_TIME = "endTime";

  /** job run data key name for job run mode. */
  public static final String DATA_JOB_RUN_MODE = "runMode";

  /** job run data key name for job definition. */
  public static final String DATA_JOB_RUN_JOB_DEF = "jobDefinition";

  /** job run data key name for workflow definition. */
  public static final String DATA_JOB_RUN_WORKFLOW_DEF = "workflowDefinition";

  /** job run data key name for bucket definition. */
  public static final String DATA_JOB_RUN_BUCKET_DEFS = "bucketDefinitions";

  /** workflow run data key name for number of active tasks. */
  public static final String DATA_WORKFLOW_RUN_NO_OF_ACTIVE_TASKS = "activeTaskCount";

  /** workflow run data key name for number of transient bulks. */
  public static final String DATA_WORKFLOW_RUN_NO_OF_TRANSIENT_BULKS = "transientBulkCount";

  /** key for timestamps . */
  public static final String TIMESTAMP = "timestamp";

  /** The key for returning the details. */
  public static final String KEY_RETURN_DETAILS = "returnDetails";

  /** prefix for system variables/parameters. */
  public static final String SYSTEM_PARAMETER_PREFIX = "_";
  
  /** prefix for temporary system variables/parameters. */
  public static final String TEMP_PREFIX = "_temp";

  /** prevent instance creation. */
  private JobManagerConstants() {
    throw new IllegalStateException("instance creation not allowed.");
  }
}
