/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager;

/**
 * The Job Mode.
 */
public enum JobRunMode {
  /** standard mode (default). */
  STANDARD("standard"),
  /** run once mode. */
  RUNONCE("runOnce");

  /** job mode. */
  private final String _mode;

  /**
   * @param n
   *          mode name
   */
  JobRunMode(final String n) {
    _mode = n;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return _mode;
  }
}
