/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.taskgenerator;

import org.eclipse.smila.jobmanager.JobManagerException;

/**
 * Exception thrown by task generators if errors occur when generating tasks.
 */
public class TaskGeneratorException extends JobManagerException {

  /** is serializable. */
  private static final long serialVersionUID = 1L;

  /**
   * create exception with description, recoverable flag will be false.
   */
  public TaskGeneratorException(final String message) {
    super(message);
  }

  /**
   * create exception with description and cause, recoverable flag will be derived from cause.
   */
  public TaskGeneratorException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /**
   * create exception with description and custom recoverable flag.
   */
  public TaskGeneratorException(final String message, final boolean recoverable) {
    super(message, recoverable);
  }

  /**
   * create exception with description,cause and custom recoverable flag.
   */
  public TaskGeneratorException(final String message, final Throwable cause, final boolean recoverable) {
    super(message, cause, recoverable);
  }
}
