package org.eclipse.smila.jobmanager.persistence.zk;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.Watcher.Event.EventType;
import org.eclipse.smila.jobmanager.persistence.JobRunListener;

/** Implements a (zookeeper) Watcher for being informed about job run completion. */
class JobRunWatcher implements Watcher {

  /** ZK node which I'm interested for. */
  public static final String JOB_ROOT_ZK_PATH = "/smila/jobmanager/jobs/";

  /** private log. */
  private final Log _log = LogFactory.getLog(getClass());

  /** Listener to inform about job run completion events. */
  private JobRunListener _jobRunListener;

  /**
   * @param jobRunListener
   *          listener that is interested in job run events.
   */
  public JobRunWatcher(final JobRunListener jobRunListener) {
    _jobRunListener = jobRunListener;
  }

  @Override
  public void process(WatchedEvent event) {
    // check if event is triggered on ZK node I'm interested in and is delete-event        
    if (event.getPath() != null && event.getPath().startsWith(JOB_ROOT_ZK_PATH)
      && event.getType() == EventType.NodeDeleted) {

      final String jobName = event.getPath().substring(JOB_ROOT_ZK_PATH.length());
      if (_jobRunListener != null) {
        _jobRunListener.notifiyAboutJobRunCompletion(jobName);
      }
    } else {
      _log.warn("JobRunWatcher shouldn't get any other events, was: " + event.toString());
    }
  }

}
