/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore;

/**
 * Subclass of {@link ObjectStoreException} for errors that are caused by invalid arguments or other conditions that
 * make it impossible to perform an operation. Subclasses may describe the error situation in more detail. It does not
 * make sense for the client to retry the operation without further preparations.
 */
public class BadRequestException extends ObjectStoreException {
  /** because it's serializable ... */
  private static final long serialVersionUID = 1L;

  /** create exception with description and causing exception. */
  public BadRequestException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** create exception with description only. */
  public BadRequestException(final String message) {
    super(message);
  }

  /** create exception from causing exception. */
  public BadRequestException(final Throwable cause) {
    super(cause);
  }

}
