/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.bulkbuilder;

/**
 * constants used by bulkbuilder components.
 */
public abstract class BulkbuilderConstants {

  /** name of bundle. Used to read configs. */
  public static final String BUNDLE_ID = "org.eclipse.smila.bulkbuilder";

  /** name of the bulk builder worker. */
  public static final String BULK_BUILDER_WORKER_NAME = "bulkbuilder";

  /** name of the inserted records slot. */
  public static final String BULK_BUILDER_INSERTED_RECORDS_SLOT = "insertedRecords";

  /** name of the deleted records slot. */
  public static final String BULK_BUILDER_DELETED_RECORDS_SLOT = "deletedRecords";

  /** name of the parameter specifiying the maximum time after which to commit pending bulks in seconds. */
  public static final String TASK_PARAM_LIMIT_TIME = "bulkLimitTime";

  /** name of the parameter specifiying the maximum size of bulks. */
  public static final String TASK_PARAM_LIMIT_SIZE = "bulkLimitSize";

}
