/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/

package org.eclipse.smila.bulkbuilder.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.bulkbuilder.BulkbuilderConstants;
import org.eclipse.smila.bulkbuilder.helper.BulkbuilderServiceBase;
import org.eclipse.smila.bulkbuilder.helper.BulkbuilderTaskProvider;
import org.eclipse.smila.datamodel.validation.RecordIdValidator;
import org.osgi.service.component.ComponentContext;

/**
 * Implementation for BulkBuilderService.
 */
public class BulkbuilderServiceImpl extends BulkbuilderServiceBase {

  /** local Logger. */
  private final Log _log = LogFactory.getLog(getClass());

  /** bulkbuilder configuration. */
  private final BulkbuilderConfig _config = new BulkbuilderConfig();

  /**
   * @param context
   *          OSGi service component context.
   */
  @Override
  protected void activate(final ComponentContext context) {
    try {
      _config.readConfiguration();
    } catch (final Exception ex) {
      final String msg = "Error during activation of BulkBuilderService";
      _log.error(msg, ex);
      throw new RuntimeException(msg, ex);
    }
    try {
      final BulkbuilderTaskProvider taskProvider =
        new BulkbuilderTaskProvider(getTaskManager(), getWorkerManager(), getJobManager(),
          BulkbuilderConstants.BULK_BUILDER_WORKER_NAME);
      activateService(new Bulkbuilder(_config, getObjectStoreService(), taskProvider, getBlackboardFactory()),
        taskProvider, new RecordIdValidator());
    } catch (final Exception ex) {
      final String msg = "Error during activation of BulkBuilderService";
      _log.error(msg, ex);
      throw new RuntimeException(msg, ex);
    }
  }

  /**
   * OSGi Declarative Services service deactivation method.
   * 
   * @param context
   *          OSGi service component context.
   */
  @Override
  protected void deactivate(final ComponentContext context) {
    super.deactivate(context);
  }
}
