/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.ConnectivityManager;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.ATransformationPipelet;
import org.eclipse.smila.processing.util.ResultCollector;
import org.eclipse.smila.utils.service.ServiceUtils;
import org.eclipse.smila.utils.xml.stax.MarkerTag;
import org.eclipse.smila.utils.xml.stax.SimpleTagExtractor;
import org.eclipse.smila.utils.xml.stax.XmlSnippetHandler;
import org.eclipse.smila.utils.xml.stax.XmlSnippetSplitter;

public class XmlSplitterPipelet
extends ATransformationPipelet {
    public static final String PROP_BEGIN_TAG_NAME = "beginTagName";
    public static final String PROP_IS_BEGIN_CLOSING_TAG = "isBeginClosingTag";
    public static final String PROP_END_TAG_NAME = "endTagName";
    public static final String PROP_IS_END_CLOSING_TAG = "isEndClosingTag";
    public static final String PROP_KEY_TAG_NAME = "keyTagName";
    public static final String PROP_MAX_BUFFER_SIZE = "maxBufferSize";
    public static final String PROP_ID_SEPARATOR = "idSeparator";
    public static final String PROP_JOB_NAME = "xmlSnippetJobName";
    public static final String ATTRIBUTE_IS_XML_SNIPPET = "__isXmlSnippet";
    public static final String DEFAULT_ID_SEPARATOR = "#";
    public static final int DEFAULT_MAX_BUFFER_SIZE = 20;
    private final SimpleTagExtractor _extractor = new SimpleTagExtractor(true);
    private ConnectivityManager _connectivityManager;

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ArrayList<String> snippetRecordIds = new ArrayList<String>(recordIds.length);
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._config);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                Any isSnippet = (Any)blackboard.getMetadata(id).get((Object)ATTRIBUTE_IS_XML_SNIPPET);
                if (isSnippet != null && isSnippet.isBoolean() && isSnippet.asValue().asBoolean().booleanValue()) {
                    snippetRecordIds.add(id);
                } else {
                    paramAccessor.setCurrentRecord(id);
                    String beginTagName = paramAccessor.getRequiredParameter(PROP_BEGIN_TAG_NAME);
                    Boolean isBeginEndTag = paramAccessor.getRequiredBooleanParameter(PROP_IS_BEGIN_CLOSING_TAG);
                    String endTagName = paramAccessor.getRequiredParameter(PROP_END_TAG_NAME);
                    Boolean isEndEndTag = paramAccessor.getRequiredBooleanParameter(PROP_IS_END_CLOSING_TAG);
                    String keyTagName = paramAccessor.getRequiredParameter(PROP_KEY_TAG_NAME);
                    String idSeparator = paramAccessor.getParameter(PROP_ID_SEPARATOR, DEFAULT_ID_SEPARATOR);
                    int bufferSize = paramAccessor.getIntParameter(PROP_MAX_BUFFER_SIZE, Integer.valueOf(20));
                    String jobName = paramAccessor.getRequiredParameter(PROP_JOB_NAME);
                    MarkerTag beginTag = new MarkerTag(beginTagName, isBeginEndTag.booleanValue());
                    MarkerTag endTag = new MarkerTag(endTagName, isEndEndTag.booleanValue());
                    InternalHandler snippetHandler = new InternalHandler(keyTagName, idSeparator, jobName, bufferSize, paramAccessor);
                    XmlSnippetSplitter splitter = new XmlSnippetSplitter((XmlSnippetHandler)snippetHandler, beginTag, endTag);
                    InputStream inputStream = this.getXmlInputStream(blackboard, id, paramAccessor);
                    snippetHandler.setCurrentRecord(id, blackboard.getRecord(id).getSource());
                    splitter.read(inputStream);
                    snippetHandler.flushRecordBuffer();
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("Created " + snippetHandler.getRecordCount() + " records from processing record " + id));
                    }
                }
            }
            catch (Exception e) {
                resultCollector.addFailedResult(id, e);
            }
            ++n2;
        }
        return snippetRecordIds.toArray(new String[snippetRecordIds.size()]);
    }

    private InputStream getXmlInputStream(Blackboard blackboard, String id, ParameterAccessor paramAccessor) throws IOException, BlackboardAccessException, MissingParameterException {
        InputStream inputStream = null;
        inputStream = this.isReadFromAttribute(this.getInputType(paramAccessor)) ? this.loadExternalInputStream(this.readStringInput(blackboard, id, paramAccessor)) : blackboard.getAttachmentAsStream(id, this.getInputName(paramAccessor));
        return inputStream;
    }

    private ConnectivityManager getConnectivityManager() throws InterruptedException {
        if (this._connectivityManager == null) {
            this.setConnectivityManager((ConnectivityManager)ServiceUtils.getService(ConnectivityManager.class));
        }
        return this._connectivityManager;
    }

    public void setConnectivityManager(ConnectivityManager connectivityManager) {
        this._connectivityManager = connectivityManager;
    }

    private InputStream loadExternalInputStream(String attrtibuteValue) throws IOException {
        InputStream stream = null;
        if (attrtibuteValue != null && attrtibuteValue.trim().length() > 0) {
            if (attrtibuteValue.startsWith("file")) {
                URL url = new URL(attrtibuteValue);
                stream = new FileInputStream(String.valueOf(url.getAuthority()) + url.getPath());
            } else if (attrtibuteValue.startsWith("http")) {
                URL url = new URL(attrtibuteValue);
                HttpClient httpClient = new HttpClient();
                GetMethod getMethod = new GetMethod(url.toString());
                httpClient.executeMethod((HttpMethod)getMethod);
                stream = getMethod.getResponseBodyAsStream();
            } else {
                stream = new FileInputStream(attrtibuteValue);
            }
        }
        return stream;
    }

    class InternalHandler
    implements XmlSnippetHandler {
        private String _currentId;
        private String _source;
        private int _recordCounter;
        private int _countById;
        private final String _keyTagName;
        private final String _idSeparator;
        private final String _jobName;
        private final int _bufferSize;
        private final List<Record> _recordBuffer = new ArrayList<Record>();
        private final ParameterAccessor _paramAccessor;

        public InternalHandler(String keyTagName, String idSeparator, String jobName, int bufferSize, ParameterAccessor paramAccessor) {
            this._keyTagName = keyTagName;
            this._idSeparator = idSeparator;
            this._jobName = jobName;
            this._bufferSize = bufferSize;
            this._paramAccessor = paramAccessor;
        }

        void setCurrentRecord(String id, String source) {
            this._currentId = id;
            this._source = source;
            this._countById = 0;
        }

        int getRecordCount() {
            return this._recordCounter;
        }

        public void flushRecordBuffer() throws ConnectivityException, InterruptedException {
            if (!this._recordBuffer.isEmpty()) {
                try {
                    XmlSplitterPipelet.this.getConnectivityManager().add(this._recordBuffer.toArray(new Record[this._recordBuffer.size()]), this._jobName);
                }
                finally {
                    this._recordBuffer.clear();
                }
            }
        }

        public void handleSnippet(byte[] snippet) {
            block10: {
                ++this._countById;
                String snippetId = null;
                try {
                    List keys = XmlSplitterPipelet.this._extractor.getTags(this._keyTagName, (InputStream)new ByteArrayInputStream(snippet));
                    if (!keys.isEmpty()) {
                        snippetId = String.valueOf(this._currentId) + this._idSeparator + (String)keys.get(0);
                        Record record = DataFactory.DEFAULT.createRecord(snippetId, this._source);
                        if (XmlSplitterPipelet.this.isStoreInAttribute(XmlSplitterPipelet.this.getOutputType(this._paramAccessor))) {
                            record.getMetadata().put(XmlSplitterPipelet.this.getOutputName(this._paramAccessor), new String(snippet, "utf-8"));
                        } else {
                            record.setAttachment(XmlSplitterPipelet.this.getOutputName(this._paramAccessor), snippet);
                        }
                        record.getMetadata().put(XmlSplitterPipelet.ATTRIBUTE_IS_XML_SNIPPET, Boolean.valueOf(true));
                        ++this._recordCounter;
                        this._recordBuffer.add(record);
                        if (this._recordBuffer.size() > this._bufferSize) {
                            this.flushRecordBuffer();
                        }
                    } else {
                        if (XmlSplitterPipelet.this._log.isWarnEnabled()) {
                            XmlSplitterPipelet.this._log.warn((Object)("could not find tag " + this._keyTagName + " in snippet number " + this._countById + " of record " + this._currentId));
                        }
                        if (XmlSplitterPipelet.this._log.isTraceEnabled()) {
                            XmlSplitterPipelet.this._log.trace((Object)("snippet content: " + new String(snippet)));
                        }
                    }
                }
                catch (Exception e) {
                    if (XmlSplitterPipelet.this._log.isErrorEnabled()) {
                        XmlSplitterPipelet.this._log.error((Object)("error creating record for xml snippet number " + this._countById + " with id " + snippetId + " of record " + this._currentId), (Throwable)e);
                    }
                    if (!XmlSplitterPipelet.this._log.isTraceEnabled()) break block10;
                    XmlSplitterPipelet.this._log.trace((Object)("snippet content: " + new String(snippet)));
                }
            }
        }
    }
}

