/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.axis2.util.Counter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.wsdl.util.WSDLDefinitionWrapper;
import org.apache.axis2.wsdl.util.WSDLWrapperImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WSDLWrapperSaveImpl
implements WSDLWrapperImpl {
    private static final Log log = LogFactory.getLog((Class)WSDLWrapperSaveImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static final String myClassName = "WSDLWrapperSaveImpl";
    static final long serialVersionUID = -2788807375814097409L;
    private Definition wsdlDefinition = null;
    private URL wsdlURL = null;
    private String wsdlExplicitURI = null;
    private String wsdlDocumentBaseURI = null;
    private Counter accessCount = null;
    private boolean safeToSerialize = true;
    private boolean hasBeenSaved = false;
    private boolean hasBeenUpdatedSinceSaving = false;
    private File savedDefinitionFile = null;
    private String savedFilename = null;

    public WSDLWrapperSaveImpl(Definition def) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"WSDLWrapperSaveImpl(Definition def) called");
            log.debug((Object)JavaUtils.callStackToString());
        }
        this.prepare(def, null);
    }

    public WSDLWrapperSaveImpl(Definition def, URL wURL) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"WSDLWrapperSaveImpl(Definition def, URL wURL) called");
            log.debug((Object)JavaUtils.callStackToString());
        }
        this.prepare(def, wURL);
    }

    private void prepare(Definition def, URL wURL) {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.prepare()");
        }
        this.wsdlDefinition = def;
        this.wsdlURL = wURL;
        this.accessCount = new Counter();
        this.releaseResources();
    }

    public Definition getUnwrappedDefinition() {
        this.getWrappedDefinitionForUse();
        Definition def = this.wsdlDefinition != null && this.wsdlDefinition instanceof WSDLDefinitionWrapper ? ((WSDLDefinitionWrapper)this.wsdlDefinition).getUnwrappedDefinition() : this.wsdlDefinition;
        return def;
    }

    public void setDefinitionToWrap(Definition d) {
        this.wsdlDefinition = d;
    }

    public void setWSDLLocation(String uriLocation) {
        if (uriLocation != null) {
            try {
                this.wsdlURL = new URL(uriLocation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getWSDLLocation() {
        if (this.wsdlURL != null) {
            return this.wsdlURL.toString();
        }
        return null;
    }

    public void close() {
    }

    public void setDocumentBaseURI(String d) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.setDocumentBaseURI(" + d + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.setDocumentBaseURI(d);
        }
        this.doneUsingWrappedDefinition();
    }

    public String getDocumentBaseURI() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getDocumentBaseURI()");
        }
        this.getWrappedDefinitionForUse();
        String results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getDocumentBaseURI();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void setQName(QName n) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.setQName(" + n + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.setQName(n);
        }
        this.doneUsingWrappedDefinition();
    }

    public QName getQName() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getQName()");
        }
        this.getWrappedDefinitionForUse();
        QName results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getQName();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void setTargetNamespace(String t) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.setTargetNamespace(" + t + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.setTargetNamespace(t);
        }
        this.doneUsingWrappedDefinition();
    }

    public String getTargetNamespace() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getTargetNamespace()");
        }
        this.getWrappedDefinitionForUse();
        String results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getTargetNamespace();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.addNamespace(" + prefix + ", " + namespaceURI + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.addNamespace(prefix, namespaceURI);
        }
        this.doneUsingWrappedDefinition();
    }

    public String removeNamespace(String prefix) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.removeNamespace(" + prefix + ")"));
        }
        this.getWrappedDefinitionForUse();
        String results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.removeNamespace(prefix);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public String getNamespace(String prefix) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.getNamespace(" + prefix + ")"));
        }
        this.getWrappedDefinitionForUse();
        String results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getNamespace(prefix);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public String getPrefix(String namespaceURI) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.getPrefix(" + namespaceURI + ")"));
        }
        this.getWrappedDefinitionForUse();
        String results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getPrefix(namespaceURI);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getNamespaces() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getNamespaces()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getNamespaces();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public List getNativeAttributeNames() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getNativeAttributeNames()");
        }
        this.getWrappedDefinitionForUse();
        List results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getNativeAttributeNames();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void setTypes(Types types) {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.setTypes()");
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.setTypes(types);
        }
        this.doneUsingWrappedDefinition();
    }

    public Types getTypes() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getTypes()");
        }
        this.getWrappedDefinitionForUse();
        Types results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getTypes();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void addImport(Import importDef) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.addImport(" + importDef + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.addImport(importDef);
        }
        this.doneUsingWrappedDefinition();
    }

    public Import removeImport(Import importDef) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.removeImport(" + importDef + ")"));
        }
        this.getWrappedDefinitionForUse();
        Import results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.removeImport(importDef);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public List getImports(String namespaceURI) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.getImports(" + namespaceURI + ")"));
        }
        this.getWrappedDefinitionForUse();
        List results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getImports(namespaceURI);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getImports() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getImports()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getImports();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void addMessage(Message message) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.addMessage(" + message + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.addMessage(message);
        }
        this.doneUsingWrappedDefinition();
    }

    public Message getMessage(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.getMessage(" + name + ")"));
        }
        this.getWrappedDefinitionForUse();
        Message results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getMessage(name);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Message removeMessage(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.removeMessage(" + name + ")"));
        }
        this.getWrappedDefinitionForUse();
        Message results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.removeMessage(name);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getMessages() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getMessages()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getMessages();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void addBinding(Binding binding) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.addBinding(" + binding + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.addBinding(binding);
        }
        this.doneUsingWrappedDefinition();
    }

    public Binding getBinding(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.getBinding(" + name + ")"));
        }
        this.getWrappedDefinitionForUse();
        Binding results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getBinding(name);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Binding removeBinding(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.removeBinding(" + name + ")"));
        }
        this.getWrappedDefinitionForUse();
        Binding results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.removeBinding(name);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getBindings() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getBindings()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getBindings();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getAllBindings() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getAllBindings()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getAllBindings();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void addPortType(PortType portType) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.addPortType(" + portType + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.addPortType(portType);
        }
        this.doneUsingWrappedDefinition();
    }

    public PortType getPortType(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.getPortType(" + name + ")"));
        }
        this.getWrappedDefinitionForUse();
        PortType results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getPortType(name);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public PortType removePortType(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.removePortType(" + name + ")"));
        }
        this.getWrappedDefinitionForUse();
        PortType results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.removePortType(name);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getPortTypes() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getPortTypes()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getPortTypes();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getAllPortTypes() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getAllPortTypes()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getAllPortTypes();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void addService(Service service) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.addService(" + service + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.addService(service);
        }
        this.doneUsingWrappedDefinition();
    }

    public Service getService(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.getService(" + name + ")"));
        }
        this.getWrappedDefinitionForUse();
        Service results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getService(name);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Service removeService(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.removeService(" + name + ")"));
        }
        this.getWrappedDefinitionForUse();
        Service results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.removeService(name);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getServices() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getServices()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getServices();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getAllServices() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getAllServices()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getAllServices();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void setDocumentationElement(Element docEl) {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.setDocumentationElement()");
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.setDocumentationElement(docEl);
        }
        this.doneUsingWrappedDefinition();
    }

    public Element getDocumentationElement() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getDocumentationElement()");
        }
        this.getWrappedDefinitionForUse();
        Element results = null;
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getDocumentationElement();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void addExtensibilityElement(ExtensibilityElement extElement) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.addExtensibilityElement(" + extElement + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.addExtensibilityElement(extElement);
        }
        this.doneUsingWrappedDefinition();
    }

    public List getExtensibilityElements() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getExtensibilityElements()");
        }
        this.getWrappedDefinitionForUse();
        List results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getExtensibilityElements();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Binding createBinding() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createBinding()");
        }
        this.getWrappedDefinitionForUse();
        Binding results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createBinding();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public BindingFault createBindingFault() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createBindingFault()");
        }
        this.getWrappedDefinitionForUse();
        BindingFault results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createBindingFault();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public BindingInput createBindingInput() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createBindingInput()");
        }
        this.getWrappedDefinitionForUse();
        BindingInput results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createBindingInput();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public BindingOperation createBindingOperation() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createBindingOperation()");
        }
        this.getWrappedDefinitionForUse();
        BindingOperation results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createBindingOperation();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public BindingOutput createBindingOutput() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createBindingOutput()");
        }
        this.getWrappedDefinitionForUse();
        BindingOutput results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createBindingOutput();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Fault createFault() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createFault()");
        }
        this.getWrappedDefinitionForUse();
        Fault results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createFault();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Import createImport() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createImport()");
        }
        this.getWrappedDefinitionForUse();
        Import results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createImport();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Input createInput() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createInput()");
        }
        this.getWrappedDefinitionForUse();
        Input results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createInput();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Message createMessage() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createMessage()");
        }
        this.getWrappedDefinitionForUse();
        Message results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createMessage();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Operation createOperation() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createOperation()");
        }
        this.getWrappedDefinitionForUse();
        Operation results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createOperation();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Output createOutput() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createOutput()");
        }
        this.getWrappedDefinitionForUse();
        Output results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createOutput();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Part createPart() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createPart()");
        }
        this.getWrappedDefinitionForUse();
        Part results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createPart();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Port createPort() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createPort()");
        }
        this.getWrappedDefinitionForUse();
        Port results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createPort();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public PortType createPortType() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createPortType()");
        }
        this.getWrappedDefinitionForUse();
        PortType results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createPortType();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Service createService() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createService()");
        }
        this.getWrappedDefinitionForUse();
        Service results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createService();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Types createTypes() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.createTypes()");
        }
        this.getWrappedDefinitionForUse();
        Types results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.createTypes();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void setExtensionRegistry(ExtensionRegistry extReg) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.setExtensionRegistry(" + extReg + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.setExtensionRegistry(extReg);
        }
        this.doneUsingWrappedDefinition();
    }

    public ExtensionRegistry getExtensionRegistry() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getExtensionRegistry()");
        }
        this.getWrappedDefinitionForUse();
        ExtensionRegistry results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getExtensionRegistry();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public String toString() {
        this.getWrappedDefinitionForUse();
        String results = "";
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.toString();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public ExtensibilityElement removeExtensibilityElement(ExtensibilityElement extElement) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.removeExtensibilityElement(" + extElement + ")"));
        }
        this.getWrappedDefinitionForUse();
        ExtensibilityElement results = null;
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            results = this.wsdlDefinition.removeExtensibilityElement(extElement);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Object getExtensionAttribute(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.getExtensionAttribute(" + name + ")"));
        }
        this.getWrappedDefinitionForUse();
        Object results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getExtensionAttribute(name);
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public Map getExtensionAttributes() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperSaveImpl.getExtensionAttributes()");
        }
        this.getWrappedDefinitionForUse();
        Map results = null;
        if (this.wsdlDefinition != null) {
            results = this.wsdlDefinition.getExtensionAttributes();
        }
        this.doneUsingWrappedDefinition();
        return results;
    }

    public void setExtensionAttribute(QName name, Object value) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperSaveImpl.setExtensionAttribute(" + name + ",  " + value + ")"));
        }
        this.getWrappedDefinitionForUse();
        if (this.wsdlDefinition != null) {
            if (this.hasBeenSaved) {
                this.hasBeenUpdatedSinceSaving = true;
            }
            this.wsdlDefinition.setExtensionAttribute(name, value);
        }
        this.doneUsingWrappedDefinition();
    }

    private void getWrappedDefinitionForUse() {
        if (this.wsdlDefinition == null) {
            this.loadResources();
        }
        if (this.wsdlDefinition != null) {
            this.accessCount.incrementAndGet();
        }
    }

    private void doneUsingWrappedDefinition() {
        long assessors = this.accessCount.decrementAndGet();
        if (assessors == 0L) {
            this.releaseResources();
        }
    }

    public void releaseResources() {
        boolean saved = this.save();
        if (saved) {
            this.wsdlDefinition = null;
        }
    }

    public void loadResources() {
        if (this.wsdlDefinition == null) {
            this.wsdlDefinition = this.restore();
        }
    }

    private boolean save() {
        if (!this.safeToSerialize) {
            return false;
        }
        if (this.savedDefinitionFile == null) {
            try {
                this.savedDefinitionFile = File.createTempFile("wsdlDef_", null);
                this.savedFilename = this.savedDefinitionFile.getName();
                log.debug((Object)("WSDLWrapperSaveImpl.save(): temp file = [" + this.savedFilename + "]"));
            }
            catch (Exception ex) {
                log.debug((Object)("WSDLWrapperSaveImpl.save(): error creating temp file = [" + ex.getMessage() + "]"));
                this.savedDefinitionFile = null;
                this.savedFilename = null;
                this.hasBeenSaved = false;
                return false;
            }
        }
        if (this.savedDefinitionFile != null) {
            if (this.hasBeenSaved && !this.hasBeenUpdatedSinceSaving) {
                return true;
            }
            FileOutputStream outStream = null;
            ObjectOutputStream outObjStream = null;
            try {
                outStream = new FileOutputStream(this.savedDefinitionFile);
                outObjStream = new ObjectOutputStream(outStream);
                log.debug((Object)"WSDLWrapperSaveImpl.save(): saving the wsdl definition.....");
                outObjStream.writeObject(this.wsdlDefinition);
                outObjStream.flush();
                outObjStream.close();
                outStream.flush();
                outStream.close();
                this.hasBeenSaved = true;
                this.hasBeenUpdatedSinceSaving = false;
                log.debug((Object)"WSDLWrapperSaveImpl.save(): ....saved the wsdl definition.....");
                long filesize = this.savedDefinitionFile.length();
                log.debug((Object)("WSDLWrapperSaveImpl.save(): file size after save [" + filesize + "]   temp file = [" + this.savedFilename + "]"));
                log.debug((Object)"WSDLWrapperSaveImpl.save(): end - - - - - - - - - - - - - - - -");
                return true;
            }
            catch (Exception ex2) {
                this.safeToSerialize = false;
                this.hasBeenSaved = false;
                log.debug((Object)("WSDLWrapperSaveImpl.save(): error with saving the wsdl definition = [" + ex2.getClass().getName() + " : " + ex2.getMessage() + "]"), (Throwable)ex2);
                if (this.savedDefinitionFile != null) {
                    try {
                        this.savedDefinitionFile.delete();
                        this.savedDefinitionFile = null;
                        this.savedFilename = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (outObjStream != null) {
                    try {
                        outObjStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                log.debug((Object)"WSDLWrapperSaveImpl.save(): error exit - - - - - - - - - - - - - - - -");
                return false;
            }
        }
        return false;
    }

    private Definition restore() {
        Definition restoredDefinition;
        block9: {
            if (!this.hasBeenSaved) {
                return null;
            }
            if (this.savedDefinitionFile == null) {
                return null;
            }
            restoredDefinition = null;
            FileInputStream inStream = null;
            ObjectInputStream inObjStream = null;
            try {
                inStream = new FileInputStream(this.savedDefinitionFile);
                inObjStream = new ObjectInputStream(inStream);
                log.debug((Object)"WSDLWrapperSaveImpl.restore(): restoring the WSDL definition .....");
                restoredDefinition = (Definition)inObjStream.readObject();
                inObjStream.close();
                inStream.close();
                log.debug((Object)"WSDLWrapperSaveImpl.restore(): ....restored the WSDL definition .....");
            }
            catch (Exception ex2) {
                log.debug((Object)("WSDLWrapperSaveImpl.restore(): error with restoring the WSDL definition = [" + ex2.getClass().getName() + " : " + ex2.getMessage() + "]"), (Throwable)ex2);
                if (inObjStream != null) {
                    try {
                        inObjStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (inStream == null) break block9;
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        log.debug((Object)"WSDLWrapperSaveImpl.restore(): end - - - - - - - - - - - - - - - -");
        return restoredDefinition;
    }
}

