/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.objectstore;

import java.io.InputStream;
import java.util.Collection;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.StoreOutputStream;

public interface ObjectStoreService {
    public static final String KEY_STORE_NAME = "storeName";
    public static final String KEY_STORE_PROPERTIES = "storeProperties";
    public static final String KEY_OBJECT_COUNT = "objectCount";
    public static final String KEY_SIZE = "size";
    public static final String KEY_OBJECTS = "objects";

    public Collection<String> getStoreNames() throws ObjectStoreException;

    public void createStore(String var1, AnyMap var2) throws ObjectStoreException;

    public void ensureStore(String var1) throws ObjectStoreException;

    public boolean isValidStoreName(String var1);

    public boolean existsStore(String var1) throws ObjectStoreException;

    public void removeStore(String var1) throws ObjectStoreException;

    public Collection<StoreObject> getStoreObjectInfos(String var1) throws ObjectStoreException;

    public Collection<StoreObject> getStoreObjectInfos(String var1, String var2) throws ObjectStoreException;

    public AnyMap getStoreProperties(String var1) throws ObjectStoreException;

    public AnyMap getStoreInfo(String var1, boolean var2) throws ObjectStoreException;

    public byte[] getObject(String var1, String var2) throws ObjectStoreException;

    public InputStream readObject(String var1, String var2) throws ObjectStoreException;

    public void putObject(String var1, String var2, byte[] var3) throws ObjectStoreException;

    public void appendToObject(String var1, String var2, byte[] var3) throws ObjectStoreException;

    public void finishObject(String var1, String var2) throws ObjectStoreException;

    public StoreOutputStream writeObject(String var1, String var2) throws ObjectStoreException;

    public boolean existsObject(String var1, String var2) throws ObjectStoreException;

    public void removeObject(String var1, String var2) throws ObjectStoreException;

    public StoreObject getObjectInfo(String var1, String var2) throws ObjectStoreException;

    public void removeAllStores() throws ObjectStoreException;

    public void clearStore(String var1) throws ObjectStoreException;
}

