/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.objectstore.httphandler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.BinaryObjectStreamIterator;
import org.eclipse.smila.datamodel.ipc.IpcSerializationUtils;
import org.eclipse.smila.objectstore.BadRequestException;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.httphandler.AStoreHandler;

public class StoreObjectHandler
extends AStoreHandler {
    private final IpcSerializationUtils _writer = new IpcSerializationUtils(false);

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "PUT".equals(method) || "DELETE".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String storeName = this.getStoreName(requestUri);
        String objectId = this.getObjectId(requestUri);
        if ("PUT".equals(method)) {
            this.putBonObject(storeName, objectId, inputRecord);
            return null;
        }
        if ("DELETE".equals(method)) {
            this.removeObject(storeName, objectId, inputRecord);
            return null;
        }
        if (objectId.endsWith("*")) {
            return this.listObjects(storeName, objectId);
        }
        try {
            return this.readBonBulk(storeName, objectId);
        }
        catch (IllegalStateException illegalStateException) {
            return this.readJsonObject(storeName, objectId);
        }
    }

    protected Any listObjects(String storeName, String objectIdPrefix) throws ObjectStoreException {
        AnyMap result = FACTORY.createAnyMap();
        AnySeq objectList = FACTORY.createAnySeq();
        result.put("objects", (Any)objectList);
        String listObjectsPrefix = objectIdPrefix.substring(0, objectIdPrefix.length() - 1);
        Collection<StoreObject> infos = this.getObjectStoreService().getStoreObjectInfos(storeName, listObjectsPrefix);
        if (infos != null) {
            for (StoreObject objectInfo : infos) {
                AnyMap info = objectInfo.toAny();
                objectList.add((Object)info);
            }
        }
        return result;
    }

    protected BinaryObjectStreamIterator readBonBulk(String storeName, String objectId) throws ObjectStoreException, IOException {
        InputStream objectStream = null;
        try {
            objectStream = this.getObjectStoreService().readObject(storeName, objectId);
            BinaryObjectStreamIterator objects = new BinaryObjectStreamIterator(objectStream);
            objects.hasNext();
            return objects;
        }
        catch (IllegalStateException ex) {
            IOUtils.closeQuietly(objectStream);
            throw ex;
        }
    }

    protected Any readJsonObject(String storeName, String objectId) throws ObjectStoreException, IOException {
        InputStream objectStream = this.getObjectStoreService().readObject(storeName, objectId);
        try {
            Any any = this._writer.jsonStream2any(objectStream);
            return any;
        }
        catch (RuntimeException ex) {
            throw new BadRequestException("Object '" + objectId + "' seems to be neither in BON nor in JSON format: " + ex.getMessage(), ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)objectStream);
        }
    }

    protected void putBonObject(String storeName, String objectId, Record inputRecord) throws ObjectStoreException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this._writer.record2BinaryStream((OutputStream)buffer, inputRecord);
            this.getObjectStoreService().putObject(storeName, objectId, buffer.toByteArray());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error converting the input record to BON", ex);
        }
    }

    protected void removeObject(String storeName, String objectId, Record inputRecord) throws ObjectStoreException {
        this.getObjectStoreService().removeObject(storeName, objectId);
    }

    protected int getSuccessStatus(String requestMethod, String requestUri, Record inputRecord, Object resultObject) {
        if ("GET".equals(requestMethod) && resultObject instanceof BinaryObjectStreamIterator) {
            try {
                return ((BinaryObjectStreamIterator)resultObject).hasNext() ? 200 : 204;
            }
            catch (IOException ex) {
                throw new RuntimeException("Error reading from ObjectStore", ex);
            }
        }
        return super.getSuccessStatus(requestMethod, requestUri, inputRecord, resultObject);
    }

    protected void writeResultObject(OutputStream responseStream, Object resultObject) throws IOException {
        block7: {
            if (resultObject instanceof BinaryObjectStreamIterator) {
                BinaryObjectStreamIterator objects = (BinaryObjectStreamIterator)resultObject;
                try {
                    try {
                        while (objects.hasNext()) {
                            this._writer.any2JsonStream(responseStream, objects.next());
                            responseStream.write(10);
                        }
                        break block7;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Error reading from ObjectStore", ex);
                    }
                }
                finally {
                    objects.close();
                }
            }
            super.writeResultObject(responseStream, resultObject);
        }
    }
}

