/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import javax.xml.namespace.QName;

public class QNameUtils {
    private QNameUtils() {
    }

    public static String fromQName(QName qName) {
        return "{" + qName.getNamespaceURI() + "}" + qName.getLocalPart();
    }

    public static QName toQName(String string) {
        if (string.charAt(0) != '{') {
            throw new IllegalArgumentException("Malformed QNAME: " + string);
        }
        int n = string.lastIndexOf(125);
        if (n == 0) {
            throw new IllegalArgumentException("Malformed QNAME: " + string);
        }
        return new QName(string.substring(1, n), string.substring(n + 1, string.length()));
    }
}

