/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.schema.internal;

import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.connectivity.framework.schema.ConfigurationLoader;
import org.eclipse.smila.connectivity.framework.schema.DataSourceConnectionConfigPlugin;
import org.eclipse.smila.connectivity.framework.schema.exceptions.SchemaNotFoundException;
import org.eclipse.smila.connectivity.framework.schema.exceptions.SchemaRuntimeException;
import org.eclipse.smila.connectivity.framework.schema.internal.XSDContextURIResolver;
import org.xml.sax.SAXException;

public class JaxbPluginContext {
    private final Log _log = LogFactory.getLog(JaxbPluginContext.class);
    private String _id;
    private JAXBContext _context;
    private DataSourceConnectionConfigPlugin _plugIn;
    private boolean _initialized;
    private Binder _binder;

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public JAXBContext getContext() throws SchemaNotFoundException, JAXBException {
        this.initilize();
        return this._context;
    }

    public void initilize() throws SchemaNotFoundException, JAXBException {
        if (!this._initialized) {
            this._initialized = true;
            this._plugIn = ConfigurationLoader.getPlugin(this._id);
            if (this._plugIn == null) {
                throw new SchemaNotFoundException(this._id);
            }
            this._context = ConfigurationLoader.newContext(this._id);
            if (this._context == null) {
                throw new SchemaNotFoundException(this._id);
            }
            this._binder = this._context.createBinder();
        }
    }

    private Class loadClassByName(String className) throws ClassNotFoundException {
        return this._plugIn.getClass().getClassLoader().loadClass(String.valueOf(this._plugIn.getMessagesPackage()) + "." + className);
    }

    public JAXBElement unmarshall(Object v, String className) throws JAXBException, ClassNotFoundException, SchemaNotFoundException {
        this.initilize();
        this.assertNotNull(this._binder);
        return this._binder.unmarshal(v, this.loadClassByName(className));
    }

    public Unmarshaller createValidatingUnmarshaller() throws JAXBException, SchemaNotFoundException {
        this.initilize();
        this.assertNotNull(this._context);
        Unmarshaller unmarshaller = this._context.createUnmarshaller();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            sf.setResourceResolver(new XSDContextURIResolver(sf.getResourceResolver()));
            Schema schema = sf.newSchema(Platform.getBundle((String)this._id).getEntry(this._plugIn.getSchemaLocation()));
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent ve) {
                    if (ve.getSeverity() != 0) {
                        ValidationEventLocator vel = ve.getLocator();
                        JaxbPluginContext.this._log.error((Object)("Line:Col[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + "]:" + ve.getMessage()));
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (SAXException se) {
            throw new SchemaRuntimeException("Unable to validate due to following error.", se);
        }
        return unmarshaller;
    }

    private void assertNotNull(Object o) throws SchemaNotFoundException {
        if (o == null) {
            throw new SchemaNotFoundException(this._id);
        }
    }
}

