/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.persistence.zk;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyConvertException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ipc.IpcSerializationUtils;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.taskmanager.persistence.TaskCounter;
import org.eclipse.smila.taskmanager.persistence.TaskList;
import org.eclipse.smila.zookeeper.ZkConcurrentMap;
import org.eclipse.smila.zookeeper.ZkConnection;
import org.eclipse.smila.zookeeper.ZooKeeperService;

public class ZkTaskQueue {
    public static final String ROOT_DIR_PREFIX = "/smila";
    public static final String TASKDIR_PREFIX = "/smila/tasks";
    public static final String TODODIR_SUFFIX = "/todo";
    public static final String TODOQUALIFIEDDIR_SUFFIX = "/todo_qualified";
    public static final String INPROGRESSDIR_SUFFIX = "/inprogress";
    public static final String OWNER_PROP = "inProgressBy";
    public static final String SECTION_TODO = "todo";
    public static final String SECTION_TODOQUALIFIED = "todo_qualified";
    public static final String SECTION_INPROGRESS = "inprogress";
    private final String _workerName;
    private final String _localhost;
    private long _maxNoOfTasksPerHost;
    private final NumberFormat _numberFormat;
    private final ZkConnection _zk;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final IpcSerializationUtils _ipcSerializationUtils = new IpcSerializationUtils();

    public ZkTaskQueue(ZooKeeperService service, String workerName, String localhost) {
        this(service, workerName, localhost, -1L);
    }

    public ZkTaskQueue(ZooKeeperService service, String workerName, String localhost, long maxNoOfTasksPerHost) {
        this._zk = new ZkConnection(service);
        this._workerName = workerName;
        this._localhost = localhost;
        this._maxNoOfTasksPerHost = maxNoOfTasksPerHost;
        this._numberFormat = NumberFormat.getIntegerInstance();
        this._numberFormat.setMaximumIntegerDigits(19);
        this._numberFormat.setMinimumIntegerDigits(19);
        this._numberFormat.setGroupingUsed(false);
    }

    public void disconnectZkSession() throws TaskmanagerException {
        try {
            this._zk.disconnectZkSession();
        }
        catch (Exception e) {
            throw new TaskmanagerException("Error discconnecting zookeeper session.", (Throwable)e);
        }
    }

    public long getMaxNoOfTasksPerHost() {
        return this._maxNoOfTasksPerHost;
    }

    public void setMaxNoOfTasksPerHost(long maxNoOfTasksPerHost) {
        this._maxNoOfTasksPerHost = maxNoOfTasksPerHost;
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public void put(Task task) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("put(), task = " + task));
        }
        try {
            String todoTaskPath = this.getTodoTaskPath(task.getQualifier());
            this.putTask(task, todoTaskPath);
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
    }

    public String putInProgress(Task task) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("putInProgress(), task = " + task));
        }
        try {
            String myId = String.valueOf(this._localhost) + "-" + Thread.currentThread().getName();
            task.getProperties().put(OWNER_PROP, myId);
            task.setTaskStartedProperties();
            byte[] inProgressData = this.task2Message(task);
            String inProgressNodeName = this.getInProgressTaskPath(task.getTaskId());
            try {
                this._zk.createPath(inProgressNodeName, inProgressData);
            }
            catch (KeeperException.NodeExistsException e) {
                this._log.trace((Object)("Node exists: " + (Object)((Object)e)));
            }
            String string = myId;
            return string;
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
        finally {
            task.getProperties().remove(OWNER_PROP);
        }
    }

    public Task get(String qualifier, String host) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("get(), qualifier = " + qualifier));
        }
        try {
            String todoTaskPath = this.getTodoTaskPath(qualifier);
            return this.getTask(todoTaskPath, host);
        }
        catch (TaskmanagerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
    }

    private Map<String, Task> getTasks(String path) throws Exception {
        HashMap<String, Task> tasks;
        block6: {
            tasks = new HashMap<String, Task>();
            try {
                List nodeNames = this._zk.getChildrenSorted(path);
                if (nodeNames == null || nodeNames.isEmpty()) break block6;
                int noOfNames = nodeNames.size();
                int i = 0;
                while (i < noOfNames) {
                    String nodeName = (String)nodeNames.get(i);
                    byte[] nodeData = null;
                    try {
                        nodeData = this._zk.getData(String.valueOf(path) + "/" + nodeName);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        this._log.trace((Object)("Node to get data doesn't exist anymore: " + nodeName));
                    }
                    if (nodeData != null && nodeData.length > 0) {
                        tasks.put(nodeName, this.message2Task(nodeData));
                    }
                    ++i;
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                if (!this._log.isDebugEnabled()) break block6;
                this._log.debug((Object)("Todo directory " + path + " does not exist yet."));
            }
        }
        return tasks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Task getTask(String todoTaskPath, String host) throws Exception {
        Task task = null;
        boolean hostCheckSuccessful = false;
        try {
            try {
                if (!this.isNotEmpty(todoTaskPath)) return task;
                List nodeNames = this._zk.getChildrenSorted(todoTaskPath);
                if (nodeNames == null) return task;
                if (nodeNames.isEmpty()) return task;
                hostCheckSuccessful = this.checkAndIncHostCounter(host);
                if (!hostCheckSuccessful) return task;
                int noOfNames = nodeNames.size();
                int i = 0;
                while (task == null) {
                    if (i >= noOfNames) {
                        return task;
                    }
                    task = this.tryTask(todoTaskPath, (String)nodeNames.get(i), host);
                    ++i;
                }
                return task;
            }
            catch (KeeperException.NoNodeException noNodeException) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Todo directory " + todoTaskPath + " does not exist yet."));
                }
                if (!hostCheckSuccessful) return task;
                if (task != null) return task;
                try {
                    this.decHostCounter(host);
                    return task;
                }
                catch (Exception e) {
                    this._log.warn((Object)("Error while decrementing host task counter for host '" + host + "'"), (Throwable)e);
                    return task;
                }
            }
        }
        finally {
            if (hostCheckSuccessful && task == null) {
                try {
                    this.decHostCounter(host);
                }
                catch (Exception e) {
                    this._log.warn((Object)("Error while decrementing host task counter for host '" + host + "'"), (Throwable)e);
                }
            }
        }
    }

    private boolean checkAndIncHostCounter(String host) throws Exception {
        if (host == null) {
            return true;
        }
        this._zk.ensurePathExists("/smila/taskmanager/hosts");
        ZkConcurrentMap hostsMap = new ZkConcurrentMap(this._zk, "/smila/taskmanager/hosts");
        Integer newValue = null;
        newValue = this._maxNoOfTasksPerHost == -1L ? hostsMap.add(host, 1) : hostsMap.incIfLessThan(host, this._maxNoOfTasksPerHost);
        if (newValue == null) {
            this._log.warn((Object)("Could not update host task counter for host '" + host + "', probably due to temporary overload."));
            return false;
        }
        return newValue != -1;
    }

    private Task tryTask(String todoTaskPath, String nodeName, String host) throws Exception {
        String todoNodeName = String.valueOf(todoTaskPath) + "/" + nodeName;
        byte[] nodeData = null;
        try {
            nodeData = this._zk.getData(todoNodeName);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            this._log.trace((Object)("Node to get data doesn't exist anymore: " + todoNodeName));
        }
        if (nodeData != null && nodeData.length > 0) {
            String myId;
            String inProgressNodeName;
            Task task = this.message2Task(nodeData);
            if (host != null) {
                task.getProperties().put("workerHost", host);
            }
            if (this.checkTaskProperty(inProgressNodeName = this.getInProgressTaskPath(task.getTaskId()), OWNER_PROP, myId = this.putInProgress(task))) {
                try {
                    this._zk.deleteNode(todoNodeName);
                    task.getProperties().remove(OWNER_PROP);
                    return task;
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Node to delete doesn't exist anymore: " + todoNodeName));
                    }
                    this._zk.deleteNode(inProgressNodeName);
                }
            }
        }
        return null;
    }

    public Task getInProgressTask(String taskId) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("getInProgresTask(), taskId = " + taskId));
        }
        String inProgressNodeName = this.getInProgressTaskPath(taskId);
        try {
            byte[] message = this._zk.getData(inProgressNodeName);
            Task task = this.message2Task(message);
            task.getProperties().remove(OWNER_PROP);
            String host = (String)task.getProperties().remove("workerHost");
            this.decHostCounter(host);
            return task;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            return null;
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
    }

    private void decHostCounter(String host) throws Exception {
        if (host != null) {
            this._zk.ensurePathExists("/smila/taskmanager/hosts");
            ZkConcurrentMap hostsMap = new ZkConcurrentMap(this._zk, "/smila/taskmanager/hosts");
            Integer newValue = hostsMap.decIfGreaterThan(host, 0L);
            if (newValue == null) {
                this._log.warn((Object)("Could not decrement host task counter for host '" + host + "', probably due to temporary overload."));
            } else if (newValue < 0) {
                this._log.error((Object)("Negative host counter (" + newValue + ") for host '" + host + "'!"));
            }
        }
    }

    public void delete(String taskId) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("delete(), taskId = " + taskId));
        }
        try {
            String inProgressNodeName = this.getInProgressTaskPath(taskId);
            try {
                this._zk.deleteNode(inProgressNodeName);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                throw new BadParameterTaskmanagerException("Cound not find taskId '" + taskId + "' for worker '" + this._workerName + "'.", BadParameterTaskmanagerException.Cause.taskId);
            }
        }
        catch (TaskmanagerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
    }

    public void keepAlive(String taskId) throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("keepAlive(), taskId = " + taskId));
        }
        try {
            String inProgressNodeName = this.getInProgressTaskPath(taskId);
            byte[] nodeData = this._zk.getData(inProgressNodeName);
            this._zk.setData(inProgressNodeName, nodeData);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            throw new BadParameterTaskmanagerException("Could not find taskId '" + taskId + "' for worker '" + this._workerName + "'.", BadParameterTaskmanagerException.Cause.taskId);
        }
        catch (Exception ex) {
            throw new TaskmanagerException((Throwable)ex);
        }
    }

    public boolean hasQualifiedTasks() throws Exception {
        String qualifiedTasksPath = this.getTodoQualifiedPath();
        return this.isNotEmpty(qualifiedTasksPath);
    }

    private boolean isNotEmpty(String path) throws Exception {
        Stat stat = this._zk.exists(path);
        return stat != null && stat.getNumChildren() > 0;
    }

    public TaskCounter getTaskCounter() throws TaskmanagerException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"getTaskCounter()");
        }
        try {
            String workerDir = this.getWorkerPath();
            String todoDir = String.valueOf(workerDir) + TODODIR_SUFFIX;
            String todoQualifiedDir = String.valueOf(workerDir) + TODOQUALIFIEDDIR_SUFFIX;
            String inProgressDir = String.valueOf(workerDir) + INPROGRESSDIR_SUFFIX;
            Stat todoStat = this._zk.exists(todoDir);
            Stat todoQualifiedStat = this._zk.exists(todoQualifiedDir);
            Stat inProgressStat = this._zk.exists(inProgressDir);
            int todoCount = 0;
            if (todoStat != null) {
                todoCount += todoStat.getNumChildren();
            }
            if (todoQualifiedStat != null) {
                List qualifiers = this._zk.getChildrenSorted(todoQualifiedDir);
                for (String qualifier : qualifiers) {
                    String qualifierDir = String.valueOf(todoQualifiedDir) + "/" + qualifier;
                    Stat qualfierStat = this._zk.exists(qualifierDir);
                    if (qualfierStat == null) continue;
                    todoCount += qualfierStat.getNumChildren();
                }
            }
            int inProgressCount = 0;
            if (inProgressStat != null) {
                inProgressCount = inProgressStat.getNumChildren();
            }
            return new TaskCounter(this._workerName, todoCount, inProgressCount);
        }
        catch (Exception e) {
            throw new TaskmanagerException((Throwable)e);
        }
    }

    public Collection<String> getTimedOutTasks(long timeToLiveMs) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"checkInProgressTasks()");
        }
        ArrayList<String> timedOutTasks = new ArrayList<String>();
        try {
            String inProgressPath = this.getInProgressPath();
            Stat stat = this._zk.exists(inProgressPath);
            if (stat != null && stat.getNumChildren() > 0) {
                List tasks = this._zk.getChildrenSorted(inProgressPath);
                for (String taskId : tasks) {
                    if (!this.isTaskTimedOut(inProgressPath, taskId, timeToLiveMs)) continue;
                    timedOutTasks.add(taskId);
                }
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error checking inprogress tasks of worker " + this._workerName), (Throwable)ex);
        }
        return timedOutTasks;
    }

    private boolean isTaskTimedOut(String rootPath, String taskId, long timeToLiveMs) {
        try {
            String taskNodePath = String.valueOf(rootPath) + "/" + taskId;
            Stat stat = this._zk.exists(taskNodePath);
            if (stat != null) {
                long mtime = stat.getMtime();
                long now = System.currentTimeMillis();
                if (now - mtime > timeToLiveMs) {
                    String finishNodePath;
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("reached maximum processing time (" + timeToLiveMs + " ms) for task " + taskId));
                    }
                    return this._zk.exists(finishNodePath = String.valueOf(taskNodePath) + "/finishing") == null;
                }
            }
        }
        catch (Exception ex) {
            this._log.error((Object)("Error checking task " + taskId + " for worker " + this._workerName), (Throwable)ex);
        }
        return false;
    }

    public void purge() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"purge()");
        }
        try {
            String workerDir = this.getWorkerPath();
            String todoDir = String.valueOf(workerDir) + TODODIR_SUFFIX;
            String todoQualifiedDir = String.valueOf(workerDir) + TODOQUALIFIEDDIR_SUFFIX;
            String inProgressDir = String.valueOf(workerDir) + INPROGRESSDIR_SUFFIX;
            this.purge(todoDir);
            try {
                Stat todoQualifiedStat = this._zk.exists(todoQualifiedDir);
                if (todoQualifiedStat != null && todoQualifiedStat.getNumChildren() > 0) {
                    List qualfiers = this._zk.getChildrenSorted(todoQualifiedDir);
                    for (String qualifier : qualfiers) {
                        String qualifierDir = String.valueOf(todoQualifiedDir) + "/" + qualifier;
                        this.purge(qualifierDir);
                    }
                }
            }
            catch (Exception ex) {
                this._log.warn((Object)("Error determining qualifier node of pipe " + this._workerName + " during purge"), (Throwable)ex);
            }
            this.purge(inProgressDir);
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error purging queue for worker " + this._workerName), (Throwable)ex);
        }
    }

    private void purge(String node) {
        try {
            Stat stat = this._zk.exists(node);
            if (stat != null && stat.getNumChildren() > 0) {
                List children = this._zk.getChildrenSorted(node);
                for (String childNode : children) {
                    String childPath = String.valueOf(node) + "/" + childNode;
                    try {
                        this._zk.deleteNode(childPath);
                    }
                    catch (Exception ex) {
                        this._log.warn((Object)("Failed to delete node " + childPath + " during purge"), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Failed to purge path " + node), (Throwable)ex);
        }
    }

    public void cleanEmptyNodes(long timeToLiveMs) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("cleanEmptyNodes() for " + this._workerName));
        }
        try {
            String todoDir = this.getTodoTaskPath(null);
            this.cleanEmptyNodes(todoDir, false, timeToLiveMs);
            String todoQualifiedDir = String.valueOf(this.getWorkerPath()) + TODOQUALIFIEDDIR_SUFFIX;
            this.cleanEmptyNodes(todoQualifiedDir, false, timeToLiveMs);
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error during cleaning todo queue for worker " + this._workerName), (Throwable)ex);
        }
    }

    private void cleanEmptyNodes(String node, boolean removeEmpty, long timeToLiveMs) {
        try {
            Stat stat = this._zk.exists(node);
            if (stat != null && stat.getNumChildren() > 0) {
                List children = this._zk.getChildrenSorted(node);
                for (String childNode : children) {
                    String childPath = String.valueOf(node) + "/" + childNode;
                    this.cleanEmptyNodes(childPath, true, timeToLiveMs);
                }
            }
            if (removeEmpty && (stat = this._zk.exists(node)) != null && stat.getNumChildren() == 0 && stat.getDataLength() == 0) {
                long mtime = stat.getMtime();
                long now = System.currentTimeMillis();
                if (now - mtime > timeToLiveMs) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("remove empty node " + node));
                    }
                    this._zk.deleteNode(node);
                }
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Failed to clean node " + node), (Throwable)ex);
        }
    }

    private String getTodoTaskPath(String qualifier) {
        StringBuilder todoTaskDir = new StringBuilder(this.getWorkerPath());
        if (qualifier == null) {
            todoTaskDir.append(TODODIR_SUFFIX);
        } else {
            todoTaskDir.append(TODOQUALIFIEDDIR_SUFFIX);
            todoTaskDir.append('/').append(this.encodeQualifier(qualifier));
        }
        return todoTaskDir.toString();
    }

    private String getTodoQualifiedPath() {
        return String.valueOf(this.getWorkerPath()) + TODOQUALIFIEDDIR_SUFFIX;
    }

    private String getWorkerPath() {
        StringBuilder workerPath = new StringBuilder(TASKDIR_PREFIX);
        workerPath.append('/').append(this._workerName);
        return workerPath.toString();
    }

    private String getInProgressPath() {
        return String.valueOf(this.getWorkerPath()) + INPROGRESSDIR_SUFFIX;
    }

    private String getInProgressTaskPath(String taskId) {
        return String.valueOf(this.getInProgressPath()) + "/" + taskId;
    }

    private void putTask(Task task, String path) throws Exception {
        String nodePath = String.valueOf(path) + "/" + this.createUniqueTaskNodeName(task);
        this._zk.createPath(nodePath, ZkConnection.NO_DATA);
        this._zk.setData(path, ZkConnection.NO_DATA);
        byte[] nodeData = this.task2Message(task);
        this._zk.setData(nodePath, nodeData);
    }

    private byte[] task2Message(Task task) throws IOException {
        AnyMap anyTask = task.toAny();
        byte[] message = this._ipcSerializationUtils.any2BinaryObject((Any)anyTask);
        return message;
    }

    private Task message2Task(byte[] message) throws IOException, AnyConvertException {
        Any anyTask = this._ipcSerializationUtils.binaryObject2any(message);
        Task task = Task.fromAny((Any)anyTask);
        return task;
    }

    private boolean checkTaskProperty(String nodePath, String taskPropertyName, String expectedPropertyValue) {
        try {
            byte[] nodeData = this._zk.getData(nodePath);
            if (nodeData != null) {
                Task task = this.message2Task(nodeData);
                String value = (String)task.getProperties().get(taskPropertyName);
                return expectedPropertyValue.equals(value);
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
            this._log.warn((Object)("Node doesn't exist" + nodePath));
        }
        catch (Exception e) {
            this._log.warn((Object)"Error while checking task property ", (Throwable)e);
        }
        return false;
    }

    private String createUniqueTaskNodeName(Task task) {
        StringBuilder taskNodeName = new StringBuilder();
        taskNodeName.append(this._numberFormat.format(System.nanoTime()));
        taskNodeName.append("-").append(task.getTaskId()).append("-").append(this._localhost);
        return taskNodeName.toString();
    }

    public TaskList getTaskList(String section, int maxCount) throws TaskmanagerException {
        TaskList taskList;
        block9: {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("getTaskList(): workerName=" + this._workerName + " section=" + section + " maxCount=" + maxCount));
            }
            taskList = new TaskList(this._workerName, section, 0);
            try {
                String workerDir = this.getWorkerPath();
                String todoDir = String.valueOf(workerDir) + TODODIR_SUFFIX;
                String todoQualifiedDir = String.valueOf(workerDir) + TODOQUALIFIEDDIR_SUFFIX;
                String inProgressDir = String.valueOf(workerDir) + INPROGRESSDIR_SUFFIX;
                if (section.equals(SECTION_TODO) || section.equals(SECTION_TODOQUALIFIED)) {
                    this.getTaskList(todoDir, maxCount, taskList);
                    try {
                        List qualifiers = this._zk.getChildrenSorted(todoQualifiedDir);
                        for (String qualifier : qualifiers) {
                            String qualifierDir = String.valueOf(todoQualifiedDir) + "/" + qualifier;
                            this.getTaskList(qualifierDir, maxCount, taskList);
                        }
                        break block9;
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                    break block9;
                }
                if (section.equals(SECTION_INPROGRESS)) {
                    this.getTaskList(inProgressDir, maxCount, taskList);
                    break block9;
                }
                throw new BadParameterTaskmanagerException("Accessing task pipe " + this._workerName + " with an invalid type " + section + ". ", BadParameterTaskmanagerException.Cause.workerName);
            }
            catch (TaskmanagerException tex) {
                throw tex;
            }
            catch (Exception e) {
                throw new TaskmanagerException((Throwable)e);
            }
        }
        return taskList;
    }

    private void getTaskList(String currentDir, int maxCount, TaskList taskList) throws Exception {
        Stat currentStat;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("getTaskList(): currentDir=" + currentDir + " maxCount=" + maxCount));
        }
        if ((currentStat = this._zk.exists(currentDir)) == null) {
            return;
        }
        taskList.setSize(taskList.getSize() + currentStat.getNumChildren());
        try {
            List taskIDs = this._zk.getChildrenSorted(currentDir);
            for (String taskID : taskIDs) {
                if (maxCount < 0 || taskList.getTaskNames().size() < maxCount) {
                    taskList.addTaskName(String.valueOf(currentDir) + "/" + taskID);
                    continue;
                }
                break;
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {}
    }

    public AnyMap getTaskInfo(String section, String taskName) throws TaskmanagerException {
        block8: {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("getTaskInfo(): workerName=" + this._workerName + " taskQueueType=" + section + " taskName=" + taskName));
            }
            AnyMap taskInfo = DataFactory.DEFAULT.createAnyMap();
            try {
                String workerDir = this.getWorkerPath();
                String taskDir = String.valueOf(workerDir) + "/" + section + "/" + taskName;
                Stat taskStat = this._zk.exists(taskDir);
                if (taskStat == null) break block8;
                byte[] nodeData = null;
                try {
                    nodeData = this._zk.getData(taskDir);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
                if (nodeData != null) {
                    taskInfo.put("created", (Any)this.toTimestampAny(taskStat.getCtime()));
                    taskInfo.put("modified", (Any)this.toTimestampAny(taskStat.getMtime()));
                    if (nodeData.length > 0) {
                        Task task = this.message2Task(nodeData);
                        taskInfo.put("task", (Any)task.toAny());
                    } else {
                        taskInfo.put("task", "");
                    }
                }
                return taskInfo;
            }
            catch (Exception e) {
                throw new TaskmanagerException((Throwable)e);
            }
        }
        throw new BadParameterTaskmanagerException("Task does not exist in " + this._workerName + ".", BadParameterTaskmanagerException.Cause.taskId);
    }

    private Value toTimestampAny(long timestamp) {
        return DataFactory.DEFAULT.createDateTimeValue(new Date(timestamp));
    }

    private String encodeQualifier(String qualifier) {
        return qualifier.replace('/', '_');
    }

    public void removeTasks(AnyMap filterMap) {
        this.removeTasks(this.getTodoTaskPath(null), filterMap);
        this.removeTasks(this.getInProgressPath(), filterMap);
        List nodeNames = null;
        try {
            nodeNames = this._zk.getChildrenSorted(String.valueOf(this.getWorkerPath()) + TODOQUALIFIEDDIR_SUFFIX);
        }
        catch (Exception exception) {}
        if (nodeNames != null && !nodeNames.isEmpty()) {
            int noOfNames = nodeNames.size();
            int i = 0;
            while (i < noOfNames) {
                String nodeName = (String)nodeNames.get(i);
                this.removeTasks(this.getTodoTaskPath(nodeName), filterMap);
                ++i;
            }
        }
    }

    private void removeTasks(String path, AnyMap filterMap) {
        try {
            Map<String, Task> tasks = this.getTasks(path);
            for (Map.Entry<String, Task> entry : tasks.entrySet()) {
                String nodeName = entry.getKey();
                Task task = entry.getValue();
                if (!this.checkTask(task, filterMap)) continue;
                try {
                    this._zk.deleteTree(String.valueOf(path) + "/" + nodeName);
                    String host = (String)task.getProperties().get("workerHost");
                    if (host == null) continue;
                    this.decHostCounter(host);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                }
                catch (Exception e) {
                    this._log.warn((Object)"Caught exception while removing tasks.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this._log.warn((Object)"Caught exception while removing tasks.", (Throwable)e);
        }
    }

    private boolean checkTask(Task task, AnyMap filterMap) {
        Map properties = task.getProperties();
        for (Map.Entry entry : filterMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((Any)entry.getValue()).toString();
            String propertyValue = (String)properties.get(key);
            if (propertyValue != null && propertyValue.equals(value)) continue;
            return false;
        }
        return true;
    }
}

