/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.vpu;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Statistics {
    public long numCycles;
    public long totalRunTimeMs;
    public long channelsCreated;
    public long messagesSent;
    public long messagesRcvd;
    public long numContinuations;
    public long totalContinuationBytes;
    public long runQueueEntries;
    public long numReductionsComm;
    public long numReductionsStruct;
    public long totalClientTimeMs;
    public final Map<String, PerTargetStatistics> byTarget = new HashMap<String, PerTargetStatistics>();

    public double getAvgClientTimeMs() {
        return (double)this.totalClientTimeMs / (double)this.numCycles;
    }

    public double getAvgContinuationSize() {
        return (double)this.totalContinuationBytes / (double)this.numContinuations;
    }

    public double getAvgKernelTimeMs() {
        return (double)this.getKernelTimeMs() / (double)this.numCycles;
    }

    public double getAvgRunTimeMs() {
        return (double)this.totalRunTimeMs / (double)this.numCycles;
    }

    public long getKernelTimeMs() {
        return this.totalRunTimeMs - this.totalClientTimeMs;
    }

    public void incRunTime(String string, long l) {
        PerTargetStatistics perTargetStatistics = this.target(string);
        ++perTargetStatistics.invocations;
        perTargetStatistics.totalRunTimeMs += l;
        perTargetStatistics.minRunTimeMs = Math.min(perTargetStatistics.minRunTimeMs, l);
        perTargetStatistics.maxRunTimeMs = Math.max(perTargetStatistics.maxRunTimeMs, l);
    }

    public void printToStream(PrintStream printStream) {
        printStream.println("JACOB VPU Statistics:");
        Field[] fieldArray = this.getClass().getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            printStream.print(fieldArray[i].getName());
            printStream.print(" = ");
            try {
                printStream.println(fieldArray[i].get(this));
                continue;
            }
            catch (Exception exception) {
                printStream.println(exception.toString());
            }
        }
        Method[] methodArray = this.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("get") || methodArray[i].getParameterTypes().length != 0) continue;
            printStream.print(methodArray[i].getName().substring(3));
            printStream.print(" = ");
            try {
                printStream.println(methodArray[i].invoke((Object)this, (Object[])null));
                continue;
            }
            catch (Exception exception) {
                printStream.println(exception.toString());
            }
        }
    }

    private PerTargetStatistics target(String string) {
        PerTargetStatistics perTargetStatistics = this.byTarget.get(string);
        if (perTargetStatistics == null) {
            perTargetStatistics = new PerTargetStatistics();
            this.byTarget.put(string, perTargetStatistics);
        }
        return perTargetStatistics;
    }

    public static final class PerTargetStatistics {
        public long invocations;
        public long totalRunTimeMs;
        public long minRunTimeMs = Long.MAX_VALUE;
        public long maxRunTimeMs = Long.MIN_VALUE;

        public double getAvgRunTimePerInvocation() {
            return (double)this.totalRunTimeMs / (double)this.invocations;
        }

        public String toString() {
            return "(n=" + this.invocations + ", total=" + this.totalRunTimeMs + "ms, avg=" + this.getAvgRunTimePerInvocation() + "ms, min=" + this.minRunTimeMs + "ms, max=" + this.maxRunTimeMs + "ms)";
        }
    }
}

