/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index.access;

import org.apache.lucene.search.IndexSearcher;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.index.IndexConnection;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedOperation;
import org.eclipse.smila.search.lucene.messages.advsearch.DQueryExpression;
import org.eclipse.smila.search.utils.searchresult.LuceneSearchResult;

public class DoQueryOperation
implements ISynchronizedOperation<IndexSearcher, LuceneSearchResult> {
    private final IndexConnection _connection;
    private final DQueryExpression _queryExpression;
    private final int _startPos;

    public DoQueryOperation(IndexConnection connection, DQueryExpression queryExpression, int startPos) {
        this._connection = connection;
        this._queryExpression = queryExpression;
        this._startPos = startPos;
    }

    @Override
    public LuceneSearchResult process(IndexSearcher object) throws IndexException {
        try {
            return this._connection.doQueryCallback(object, this._queryExpression, this._startPos);
        }
        catch (IndexException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IndexException("Unable to execute query", e);
        }
    }
}

