/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DNumField;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

abstract class DNumFieldCodec {
    private DNumFieldCodec() {
    }

    public static Element encode(DNumField dNumField, Element parent) throws AdvSearchException {
        Document doc = parent.getOwnerDocument();
        Element me = (Element)parent.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Field"));
        me.setAttribute("xsi:type", "NumField");
        me.setAttribute("FieldNo", String.valueOf(dNumField.getFieldNo()));
        Element child = null;
        long l = dNumField.getMin();
        child = (Element)me.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Min"));
        child.appendChild(doc.createTextNode(String.valueOf(l)));
        l = dNumField.getMax();
        child = (Element)me.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Max"));
        child.appendChild(doc.createTextNode(String.valueOf(l)));
        return me;
    }

    public static DNumField decode(Element eNumField) throws AdvSearchException {
        try {
            DNumField dNumField = new DNumField();
            dNumField.setFieldNo(Integer.parseInt(eNumField.getAttribute("FieldNo")));
            NodeList nl = eNumField.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                String data;
                long l;
                boolean isNil;
                NamedNodeMap attrs = nl.item(i).getAttributes();
                Node nilItem = attrs == null ? null : attrs.getNamedItem("xsi:nil");
                String xsiNil = nilItem == null ? null : nilItem.getNodeValue();
                boolean bl = isNil = xsiNil != null && (xsiNil.toLowerCase().equals("true") || xsiNil.equals("1"));
                if ("Min".equals(nl.item(i).getLocalName()) && nl.item(i).hasChildNodes()) {
                    if (isNil) {
                        l = Long.MIN_VALUE;
                    } else {
                        data = ((Text)nl.item(i).getFirstChild()).getData();
                        try {
                            l = Long.parseLong(data);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new AdvSearchException("Error in NumField: Illegal number format '" + data + "'");
                        }
                        dNumField.setMin(l);
                    }
                }
                if ("Max".equals(nl.item(i).getLocalName()) && nl.item(i).hasChildNodes()) {
                    if (isNil) {
                        l = Long.MAX_VALUE;
                    } else {
                        data = ((Text)nl.item(i).getFirstChild()).getData();
                        try {
                            l = Long.parseLong(data);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new AdvSearchException("Error in NumField: Illegal number format '" + data + "'");
                        }
                        dNumField.setMax(l);
                    }
                }
                ++i;
            }
            return dNumField;
        }
        catch (Exception e) {
            throw new AdvSearchException("Error in attributes to NumField!", (Throwable)e);
        }
    }
}

