/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrResponseBase;

public final class SolrUtils {
    static final String QUERY_WRAPPER_FILTER = "QueryWrapperFilter";
    public static final String ESCAPE_CHARS = "+-&|!(){}[]^~*?:\\\"";

    public static String encodeQuery(String query) throws UnsupportedEncodingException {
        return URLEncoder.encode(query, "UTF-8");
    }

    public static String escapeQuery(String query) {
        return SolrUtils.escapeQuery(query, ESCAPE_CHARS);
    }

    public static String escapeQuery(String query, String escapeChars) {
        if (StringUtils.isEmpty((String)query)) {
            return query;
        }
        int strLength = query.length();
        StringBuilder buf = new StringBuilder(strLength * 2);
        int i = 0;
        while (i < strLength) {
            char ch = query.charAt(i);
            if (escapeChars.indexOf(ch) >= 0) {
                buf.append('\\');
            }
            buf.append(ch);
            ++i;
        }
        if (buf.length() != query.length()) {
            return buf.toString();
        }
        return query;
    }

    public static boolean responseStatusIsError(SolrResponseBase response) throws SolrServerException {
        return response.getStatus() != 0;
    }

    public static String toSolrQueryFilter(String filter) {
        filter = StringUtils.remove((String)filter, (String)QUERY_WRAPPER_FILTER);
        filter = StringUtils.replace((String)filter, (String)"\\", (String)"\\\\");
        return filter;
    }

    public static String toConstQueryOnField(String fieldName, String constant) {
        return String.valueOf(fieldName) + ":\"" + SolrUtils.escapeQuery(constant) + '\"';
    }
}

