/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.deltaindexing.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingException;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingManager;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingSessionException;
import org.eclipse.smila.connectivity.deltaindexing.impl.DataSourceConnection;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;

public class DeltaIndexingManagerImpl
implements DeltaIndexingManager {
    private static final String BUNDLE_ID = "org.eclipse.smila.connectivity.deltaindexing";
    private static final String ERROR_DURING_GLOBAL_CLEAR = "Error during cleaning datasource %s during global clear() operation";
    private static final String ERROR_DURING_UNLOCK = "Error during unlocking of datasource %s";
    private static final String ERROR_DURING_GET_ENTRY_COUNTS = "Error during getting the entry count for datasource %s";
    private final Log _log = LogFactory.getLog(DeltaIndexingManagerImpl.class);
    private final Map<String, DataSourceConnection> _dataSources = Collections.synchronizedMap(new HashMap());
    private Bundle _bundle;

    protected synchronized void activate(ComponentContext context) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Activating " + this.getClass()));
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                this.start();
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Activation of " + this.getClass() + " was successfull"));
                }
            }
            catch (Throwable e) {
                this._log.error((Object)("Activation of " + this.getClass() + " was failed"), e);
                throw new RuntimeException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    protected synchronized void deactivate(ComponentContext context) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Deactivating " + this.getClass()));
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                this.stop();
            }
            catch (IOException e) {
                this._log.error((Object)("Deactivation of " + this.getClass() + " was failed"), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws IOException, ClassNotFoundException, DeltaIndexingException {
        File folder = WorkspaceHelper.createWorkingDir((String)BUNDLE_ID);
        this._bundle = Platform.getBundle((String)BUNDLE_ID);
        Map<String, DataSourceConnection> map = this._dataSources;
        synchronized (map) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    FileInputStream fis = new FileInputStream(file);
                    ObjectInputStream in = new ObjectInputStream(fis);
                    DataSourceConnection connection = null;
                    try {
                        connection = (DataSourceConnection)in.readObject();
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly((InputStream)fis);
                    }
                    connection.forceUnlockAndRollback();
                    this._dataSources.put(connection.getDataSourceId(), connection);
                }
                ++n2;
            }
        }
        this._log.info((Object)"Deltaindexing service was successfully started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() throws IOException {
        File folder = this._bundle != null ? WorkspaceHelper.createWorkingDirByBundle((Bundle)this._bundle) : WorkspaceHelper.createWorkingDir((String)BUNDLE_ID);
        this._bundle = null;
        FileUtils.cleanDirectory((File)folder);
        Map<String, DataSourceConnection> map = this._dataSources;
        synchronized (map) {
            for (String dataSource : this._dataSources.keySet()) {
                DataSourceConnection connection = this._dataSources.get(dataSource);
                File file1 = new File(folder, this.convertDatasourceToFileName(dataSource));
                FileOutputStream fos = new FileOutputStream(file1);
                ObjectOutputStream out = new ObjectOutputStream(fos);
                try {
                    out.writeObject(connection);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                    IOUtils.closeQuietly((OutputStream)fos);
                }
            }
        }
        this._log.info((Object)"Deltaindexing service was successfully stopped");
    }

    private String convertDatasourceToFileName(String dataSource) {
        return dataSource;
    }

    public boolean checkForUpdate(String sessionId, ConnectivityId id, String hash) throws DeltaIndexingSessionException, DeltaIndexingException {
        boolean result;
        DataSourceConnection dataSource;
        String value;
        if (id == null) {
            throw new DeltaIndexingException("parameter id is null");
        }
        if (hash == null) {
            throw new DeltaIndexingException("parameter hash is null");
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Checking for update " + id.getIdHash()));
        }
        if ((value = (dataSource = this.findDataSource(sessionId, id.getDataSourceId())).getHash(id)) == null) {
            return true;
        }
        boolean bl = result = !value.equals(hash);
        if (!result) {
            dataSource.put(id);
            this.visitSubCompounds(dataSource, id);
        }
        return result;
    }

    public void finish(String sessionId) throws DeltaIndexingSessionException, DeltaIndexingException {
        DataSourceConnection dataSource = this.findDataSourceBySession(sessionId);
        dataSource.unlock();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Finishing session " + sessionId + " and releasing datasource lock " + dataSource.getDataSourceId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String init(String dataSourceID) throws DeltaIndexingException {
        if (dataSourceID == null) {
            throw new DeltaIndexingException("parameter dataSourceID is null");
        }
        Map<String, DataSourceConnection> map = this._dataSources;
        synchronized (map) {
            DataSourceConnection dataSource;
            if (!this._dataSources.containsKey(dataSourceID)) {
                dataSource = new DataSourceConnection(dataSourceID);
                this._dataSources.put(dataSourceID, dataSource);
            }
            dataSource = this._dataSources.get(dataSourceID);
            String sessionId = UUID.randomUUID().toString();
            dataSource.lock(sessionId);
            return sessionId;
        }
    }

    public void visit(String sessionId, ConnectivityId id, String hash, boolean isCompound) throws DeltaIndexingSessionException, DeltaIndexingException {
        if (id == null) {
            throw new DeltaIndexingException("parameter id is null");
        }
        if (hash == null) {
            throw new DeltaIndexingException("parameter hash is null");
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Visiting " + id.getIdHash()));
        }
        DataSourceConnection dataSource = this.findDataSource(sessionId, id.getDataSourceId());
        dataSource.put(id, hash, isCompound);
        if (isCompound) {
            ConnectivityId parentId = id.getContainerId();
            dataSource.addSubCompound(parentId, id);
        }
    }

    public Iterator<ConnectivityId> obsoleteIdIterator(String sessionId, String dataSourceID) throws DeltaIndexingSessionException, DeltaIndexingException {
        if (dataSourceID == null) {
            throw new DeltaIndexingException("parameter dataSourceID is null");
        }
        DataSourceConnection dataSource = this.findDataSource(sessionId, dataSourceID);
        return dataSource.obsoleteIdIterator();
    }

    public void rollback(String sessionId) throws DeltaIndexingException {
        throw new UnsupportedOperationException("Not Implemented yet. Use case and workflow are not specified!");
    }

    public void delete(String sessionId, ConnectivityId id) throws DeltaIndexingSessionException, DeltaIndexingException {
        if (id == null) {
            throw new DeltaIndexingException("parameter id is null");
        }
        DataSourceConnection dataSource = this.findDataSource(sessionId, id.getDataSourceId());
        dataSource.delete(id);
    }

    public Iterator<ConnectivityId> obsoleteIdIterator(String sessionId, ConnectivityId id) {
        throw new UnsupportedOperationException("Not Implemented because working with fragments is not clear!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockDatasource(String dataSourceID) throws DeltaIndexingException {
        Map<String, DataSourceConnection> map = this._dataSources;
        synchronized (map) {
            try {
                DataSourceConnection connection = this._dataSources.get(dataSourceID);
                if (connection != null) {
                    connection.forceUnlockAndRollback();
                }
            }
            catch (Throwable ex) {
                this._log.error((Object)String.format(ERROR_DURING_UNLOCK, dataSourceID), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockDatasources() {
        Map<String, DataSourceConnection> map = this._dataSources;
        synchronized (map) {
            for (String dataSourceId : this._dataSources.keySet()) {
                try {
                    DataSourceConnection connection = this._dataSources.get(dataSourceId);
                    connection.forceUnlockAndRollback();
                }
                catch (Throwable ex) {
                    this._log.error((Object)String.format(ERROR_DURING_UNLOCK, dataSourceId), ex);
                }
            }
        }
    }

    public Map<String, DeltaIndexingManager.LockState> getLockStates() {
        HashMap<String, DeltaIndexingManager.LockState> lockMap = new HashMap<String, DeltaIndexingManager.LockState>();
        for (String dataSourceId : this._dataSources.keySet()) {
            try {
                DataSourceConnection connection = this._dataSources.get(dataSourceId);
                DeltaIndexingManager.LockState state = DeltaIndexingManager.LockState.UNLOCKED;
                if (connection != null && connection.getSessionId() != null) {
                    state = DeltaIndexingManager.LockState.LOCKED;
                }
                lockMap.put(dataSourceId, state);
            }
            catch (Throwable ex) {
                this._log.error((Object)String.format(ERROR_DURING_UNLOCK, dataSourceId), ex);
            }
        }
        return lockMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws DeltaIndexingException {
        Map<String, DataSourceConnection> map = this._dataSources;
        synchronized (map) {
            for (String dataSourceId : this._dataSources.keySet()) {
                try {
                    DataSourceConnection connection = this._dataSources.get(dataSourceId);
                    connection.forceUnlockAndClear();
                }
                catch (Throwable ex) {
                    this._log.error((Object)String.format(ERROR_DURING_GLOBAL_CLEAR, dataSourceId), ex);
                }
            }
            this._dataSources.clear();
        }
    }

    public void clear(String sessionId) throws DeltaIndexingSessionException, DeltaIndexingException {
        DataSourceConnection dataSource = this.findDataSourceBySession(sessionId);
        dataSource.clear();
    }

    public boolean exists(String dataSourceId) {
        return this._dataSources.containsKey(dataSourceId);
    }

    public long getEntryCount(String dataSourceId) {
        DataSourceConnection connection = this._dataSources.get(dataSourceId);
        if (connection == null) {
            return 0L;
        }
        return connection.getEntryCount();
    }

    public Map<String, Long> getEntryCounts() {
        HashMap<String, Long> entryCounts = new HashMap<String, Long>();
        for (String dataSourceId : this._dataSources.keySet()) {
            try {
                DataSourceConnection connection = this._dataSources.get(dataSourceId);
                long count = 0L;
                if (connection != null) {
                    count = connection.getEntryCount();
                }
                entryCounts.put(dataSourceId, count);
            }
            catch (Throwable ex) {
                this._log.error((Object)String.format(ERROR_DURING_GET_ENTRY_COUNTS, dataSourceId), ex);
            }
        }
        return entryCounts;
    }

    private DataSourceConnection findDataSourceBySession(String sessionId) throws DeltaIndexingSessionException {
        if (sessionId == null) {
            throw new DeltaIndexingSessionException("Invalid session id: null");
        }
        for (DataSourceConnection dsc : this._dataSources.values()) {
            if (dsc == null || !sessionId.equals(dsc.getSessionId())) continue;
            return dsc;
        }
        throw new DeltaIndexingSessionException("Invalid session id: " + sessionId);
    }

    private DataSourceConnection findDataSource(String sessionId, String dataSourceID) throws DeltaIndexingSessionException, DeltaIndexingException {
        DataSourceConnection dsc = this.findDataSourceBySession(sessionId);
        if (!dsc.getDataSourceId().equals(dataSourceID)) {
            throw new DeltaIndexingException("Invalid data source id " + dataSourceID + " for session id " + sessionId);
        }
        return dsc;
    }

    private void visitSubCompounds(DataSourceConnection dataSource, ConnectivityId id) throws DeltaIndexingException {
        Set<ConnectivityId> subCompounds = dataSource.getSubCompounds(id);
        if (subCompounds != null) {
            for (ConnectivityId subId : subCompounds) {
                dataSource.put(subId);
                this.visitSubCompounds(dataSource, subId);
            }
        }
    }
}

