/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IndexDocument
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _url;
    private String _title;
    private byte[] _content;
    private List<String> _responseHeaders;
    private List<String> _htmlMetaData;
    private List<String> _metaDataWithResponseHeaderFallBack;

    public IndexDocument(String url, String title, byte[] content, List<String> responseHeaders, List<String> htmlMetaData, List<String> metaDataWithResponseHeaderFallBack) {
        this._url = url;
        this._title = title;
        this._content = content;
        this._responseHeaders = responseHeaders;
        this._htmlMetaData = htmlMetaData;
        this._metaDataWithResponseHeaderFallBack = metaDataWithResponseHeaderFallBack;
    }

    public byte[] getContent() {
        return this._content;
    }

    public void setContent(byte[] content) {
        this._content = content;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public List<String> getHtmlMetaData() {
        return this._htmlMetaData;
    }

    public void setHtmlMetaData(List<String> metaData) {
        this._htmlMetaData = metaData;
    }

    public List<String> getResponseHeaders() {
        return this._responseHeaders;
    }

    public void setResponseHeaders(List<String> headers) {
        this._responseHeaders = headers;
    }

    public List<String> getMetaDataWithResponseHeaderFallBack() {
        return this._metaDataWithResponseHeaderFallBack;
    }

    public void setMetaDataWithResponseHeaderFallBack(List<String> metaDataWithResponseHeaderFallBack) {
        this._metaDataWithResponseHeaderFallBack = metaDataWithResponseHeaderFallBack;
    }

    public String extractFromResponseHeaders(Pattern pattern, int group) {
        String value = null;
        if (this.getResponseHeaders() != null && !this.getResponseHeaders().isEmpty()) {
            for (String responseHeader : this.getResponseHeaders()) {
                Matcher matcher = pattern.matcher(responseHeader);
                if (!matcher.find()) continue;
                value = matcher.group(group);
                break;
            }
        }
        return value;
    }
}

