/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.filter.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configuration;
import org.eclipse.smila.connectivity.framework.crawler.web.crawl.CrawlMode;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.FilterProcessor;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.IFilter;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.WorkTypeFiltersCollection;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.impl.CrawlScopeFilter;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.FollowLinksType;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Outlink;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.html.HTMLMetaTags;

public class FilterProcessorImpl
implements FilterProcessor {
    private static final Log LOG = LogFactory.getLog(FilterProcessorImpl.class);
    private final Configuration _conf;

    public FilterProcessorImpl(Configuration conf) {
        this._conf = conf;
    }

    @Override
    public CrawlMode evaluateUrlFilters(Outlink link) {
        CrawlMode result = CrawlMode.Skip;
        CrawlScopeFilter crawlScopeFilter = this._conf.getCrawlScopeFilter();
        if (crawlScopeFilter.matches(link)) {
            result = this.evaluateFilters(this._conf.getUrlFilters(), link);
        }
        return result;
    }

    @Override
    public CrawlMode evaluateHtmlMetaTagFilters(HTMLMetaTags htmlMetaTags) {
        return this.evaluateFilters(this._conf.getMetaTagFilters(), htmlMetaTags);
    }

    public CrawlMode evaluateFilters(WorkTypeFiltersCollection filters, Object test) {
        CrawlMode result = CrawlMode.Index;
        List<IFilter> unselectFilters = filters.getUnselectFilters();
        if (unselectFilters.size() > 0) {
            for (IFilter filter : unselectFilters) {
                if (!filter.matches(test)) continue;
                FollowLinksType followLinks = this._conf.getFollowLinks();
                if (followLinks.equals((Object)FollowLinksType.FOLLOW)) {
                    result = CrawlMode.AnalyzeOnly;
                    break;
                }
                if (followLinks.equals((Object)FollowLinksType.NO_FOLLOW)) {
                    result = CrawlMode.Skip;
                    break;
                }
                if (!followLinks.equals((Object)FollowLinksType.FOLLOW_LINKS_WITH_CORRESPONDING_SELECT_FILTER)) continue;
                if (this.hasCorrespondingSelectFilter(filters, test)) break;
                result = CrawlMode.AnalyzeOnly;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Crawl mode set to " + result.name() + "  " + test));
        }
        return result;
    }

    @Override
    public boolean evaluateContentTypeFilters(String contentType) {
        boolean result = true;
        List<IFilter> unselectFilters = this._conf.getContentTypeFilters().getUnselectFilters();
        for (IFilter filter : unselectFilters) {
            if (!filter.matches(contentType)) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean hasCorrespondingSelectFilter(WorkTypeFiltersCollection filters, Object test) {
        boolean filterMatches = false;
        List<IFilter> selectFilters = filters.getSelectFilters();
        if (selectFilters.size() > 0) {
            for (IFilter filter : selectFilters) {
                if (!filter.matches(test)) continue;
                filterMatches = true;
            }
        }
        return filterMatches;
    }
}

