/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.http;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.crawler.web.auth.Authentication;
import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configuration;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.FilterProcessor;
import org.eclipse.smila.connectivity.framework.crawler.web.http.HttpOutput;
import org.eclipse.smila.connectivity.framework.crawler.web.http.HttpStatus;
import org.eclipse.smila.connectivity.framework.crawler.web.http.Response;
import org.eclipse.smila.connectivity.framework.crawler.web.http.RobotRulesParser;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Content;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Outlink;
import org.eclipse.smila.connectivity.framework.crawler.web.util.GZIPUtils;

public abstract class HttpBase {
    public static final int BUFFER_SIZE = 8192;
    private static final Log LOG = LogFactory.getLog(HttpBase.class);
    private static final byte[] EMPTY_CONTENT = new byte[0];
    protected String _userAgent;
    protected String _referrer;
    protected List<Header> _headers = new ArrayList<Header>();
    protected boolean _useHttp11;
    protected String _proxyHost;
    protected int _proxyPort;
    protected String _proxyLogin;
    protected String _proxyPassword;
    protected boolean _useProxy;
    protected int _maxLengthBytes;
    protected int _timeout;
    protected int _connectTimeout;
    protected int _readTimeout;
    protected Authentication _authentication;
    protected boolean _cookiesEnabled;
    private final RobotRulesParser _robots = new RobotRulesParser();
    private Configuration _conf;

    public void setConf(Configuration conf) {
        this._conf = conf;
        this._proxyHost = conf.get("http.proxy.host");
        this._proxyPort = conf.getInt("http.proxy.port");
        this._proxyLogin = conf.get("http.proxy.login");
        this._proxyPassword = conf.get("http.proxy.password");
        this._useProxy = this._proxyHost != null && this._proxyHost.length() > 0;
        this._timeout = conf.getInt("http.timeout");
        this._connectTimeout = conf.getInt("http.connect.timeout");
        this._readTimeout = conf.getInt("http.read.timeout");
        this._userAgent = HttpBase.getAgentString(conf.get("http.agent.name"), conf.get("http.agent.version"), conf.get("http.agent.description"), conf.get("http.agent.url"), conf.get("http.agent.email"));
        this._maxLengthBytes = conf.getInt("http.max.length.bytes");
        this._useHttp11 = conf.getBoolean("http.http11");
        this._authentication = conf.getAuthentication();
        this._cookiesEnabled = conf.getBoolean("http.enable.cookies");
        this._referrer = conf.get("http.referer");
        this._robots.setConf(conf);
    }

    public Configuration getConf() {
        return this._conf;
    }

    public HttpOutput getHttpOutput(Outlink link, FilterProcessor filterProcessor) {
        try {
            String urlString = link.getUrlString();
            URL url = link.getUrl();
            try {
                if (!this._robots.isAllowed(this, url)) {
                    LOG.info((Object)("Url " + urlString + " is denied by robots.txt rules"));
                    return new HttpOutput(null, new HttpStatus(18, urlString));
                }
            }
            catch (Exception exception) {
                LOG.info((Object)("Exception checking robot rules for " + urlString + ": " + exception));
            }
            Response response = this.getResponse(link.getUrlString(), filterProcessor);
            int code = response.getCode();
            byte[] content = response.getContent();
            Content c = content == null ? new Content(urlString, urlString, EMPTY_CONTENT, response.getHeader("Content-Type"), response.getHeaders()) : new Content(urlString, urlString, content, response.getHeader("Content-Type"), response.getHeaders());
            if (code == 200) {
                return new HttpOutput(c);
            }
            if (code == 410) {
                return new HttpOutput(c, new HttpStatus(11, "Http: " + code + " url=" + urlString));
            }
            if (code >= 300 && code < 400) {
                int protocolStatusCode;
                String location = response.getHeader("Location");
                if (location == null) {
                    location = response.getHeader("location");
                }
                if (location == null) {
                    location = "";
                }
                url = new URL(url, location);
                switch (code) {
                    case 300: {
                        protocolStatusCode = 12;
                        break;
                    }
                    case 301: 
                    case 305: {
                        protocolStatusCode = 12;
                        break;
                    }
                    case 302: 
                    case 303: 
                    case 307: {
                        protocolStatusCode = 13;
                        break;
                    }
                    case 304: {
                        protocolStatusCode = 21;
                        break;
                    }
                    default: {
                        protocolStatusCode = 12;
                    }
                }
                return new HttpOutput(c, new HttpStatus(protocolStatusCode, url));
            }
            if (code == 400) {
                LOG.debug((Object)("400 Bad request: " + url));
                return new HttpOutput(c, new HttpStatus(11, url));
            }
            if (code == 401) {
                LOG.debug((Object)"401 Authentication Required");
                return new HttpOutput(c, new HttpStatus(17, "Authentication required: " + urlString));
            }
            if (code == 404) {
                return new HttpOutput(c, new HttpStatus(14, url));
            }
            if (code == 410) {
                return new HttpOutput(c, new HttpStatus(11, url));
            }
            if (code == -1) {
                return new HttpOutput(c, new HttpStatus(20, url));
            }
            return new HttpOutput(c, new HttpStatus(16, "Http code=" + code + ", url=" + url));
        }
        catch (IOException exception) {
            return new HttpOutput(null, new HttpStatus(exception));
        }
    }

    private static String getAgentString(String agentName, String agentVersion, String agentDesc, String agentURL, String agentEmail) {
        if ((agentName == null || agentName.trim().length() == 0) && LOG.isFatalEnabled()) {
            LOG.fatal((Object)"No User-Agent set!");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(agentName);
        if (agentVersion != null) {
            buf.append("/");
            buf.append(agentVersion);
        }
        if (agentDesc != null && agentDesc.length() != 0 || agentEmail != null && agentEmail.length() != 0 || agentURL != null && agentURL.length() != 0) {
            buf.append(" (");
            if (agentDesc != null && agentDesc.length() != 0) {
                buf.append(agentDesc);
                if (agentURL != null || agentEmail != null) {
                    buf.append("; ");
                }
            }
            if (agentURL != null && agentURL.length() != 0) {
                buf.append(agentURL);
                if (agentEmail != null) {
                    buf.append("; ");
                }
            }
            if (agentEmail != null && agentEmail.length() != 0) {
                buf.append(agentEmail);
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public byte[] processGzipEncoded(byte[] compressed, String url) throws IOException {
        byte[] content;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"uncompressing....");
        }
        if ((content = GZIPUtils.unzipBestEffort(compressed, this.getMaxLengthBytes())) == null) {
            throw new IOException("unzipBestEffort returned null");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("fetched " + compressed.length + " bytes of compressed content (expanded to " + content.length + " bytes) from " + url));
        }
        return content;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public boolean getUseHttp11() {
        return this._useHttp11;
    }

    public int getMaxLengthBytes() {
        return this._maxLengthBytes;
    }

    public List<Header> getHeaders() {
        return this._headers;
    }

    public void setHeaders(List<Header> headersList) {
        this._headers = headersList;
    }

    public String getReferer() {
        return this._referrer;
    }

    public void setReferer(String refererValue) {
        this._referrer = refererValue;
    }

    public boolean isCookiesEnabled() {
        return this._cookiesEnabled;
    }

    public void setCookiesEnabled(boolean enableCookies) {
        this._cookiesEnabled = enableCookies;
    }

    protected abstract Response getResponse(String var1) throws IOException;

    protected abstract Response getResponse(String var1, FilterProcessor var2) throws IOException;
}

