/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.net;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configuration;
import org.eclipse.smila.connectivity.framework.crawler.web.net.UrlNormalizer;

public class UrlNormalizerFactory {
    private static final Log LOG = LogFactory.getLog(UrlNormalizerFactory.class);
    private final Configuration _conf;

    public UrlNormalizerFactory(Configuration conf) {
        this._conf = conf;
    }

    public UrlNormalizer getNormalizer() {
        String urlNormalizer = null;
        UrlNormalizer normalizer = (UrlNormalizer)this._conf.getObject(UrlNormalizer.class.getName());
        if (normalizer == null) {
            urlNormalizer = this._conf.get("urlnormalizer.class");
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Using URL normalizer: " + urlNormalizer));
            }
            try {
                Class<?> normalizerClass = Class.forName(urlNormalizer);
                normalizer = (UrlNormalizer)normalizerClass.newInstance();
                normalizer.setConf(this._conf);
                this._conf.setObject(UrlNormalizer.class.getName(), normalizer);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Couldn't create " + urlNormalizer, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Couldn't create " + urlNormalizer, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Couldn't create " + urlNormalizer, e);
            }
        }
        return normalizer;
    }
}

