/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.httphandler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.bulkbuilder.InvalidJobException;
import org.eclipse.smila.bulkbuilder.WorkflowRunInfo;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.validation.InvalidRecordException;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;

public class BulkbuilderHandler
extends JsonRequestHandler {
    public static final String KEY_WORKFLOW_RUN_ID = "workflowRunId";
    public static final String KEY_JOB_RUN_ID = "jobRunId";
    public static final String KEY_URL = "url";
    public static final String JOB_URL_PREFIX = "/jobmanager/jobs";
    private BulkbuilderService _service;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String jobName = this.getJobName(requestUri);
        WorkflowRunInfo workflowRunInfo = null;
        if ("POST".equals(method)) {
            workflowRunInfo = inputRecord != null ? this._service.addRecord(jobName, inputRecord) : this._service.commitJob(jobName);
        } else if ("DELETE".equals(method)) {
            workflowRunInfo = inputRecord != null ? this._service.deleteRecord(jobName, inputRecord) : this._service.commitJob(jobName);
        }
        if (workflowRunInfo != null) {
            return BulkbuilderHandler.createResponse(workflowRunInfo, jobName, this.getRequestHost(), this.getRootContextPath());
        }
        return null;
    }

    public static Any createResponse(WorkflowRunInfo workflowRunInfo, String jobName, String requestHost, String rootContext) throws MalformedURLException {
        AnyMap result = FACTORY.createAnyMap();
        result.put(KEY_WORKFLOW_RUN_ID, workflowRunInfo.getWorkflowId());
        result.put(KEY_JOB_RUN_ID, workflowRunInfo.getJobId());
        String workflowRunPath = String.valueOf(jobName) + "/" + workflowRunInfo.getJobId() + "/workflowrun/" + workflowRunInfo.getWorkflowId();
        URL workflowRunUrl = URLCreator.create((String)requestHost, (String)(String.valueOf(rootContext) + JOB_URL_PREFIX), (String)workflowRunPath);
        result.put(KEY_URL, workflowRunUrl.toString());
        return result;
    }

    private String getJobName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "POST".equals(method) || "DELETE".equals(method);
    }

    protected int getSuccessStatus(String method, String requestUri) {
        return 202;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof InvalidRecordException) {
            return 400;
        }
        if (ex instanceof JsonParseException || ex.getCause() != null && ex.getCause() instanceof JsonParseException) {
            return 400;
        }
        if (ex instanceof InvalidJobException) {
            return 404;
        }
        if (ex instanceof BulkbuilderException) {
            return 503;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    public void setBulkbuilderService(BulkbuilderService service) {
        this._service = service;
    }

    public void unsetBulkbuilderService(BulkbuilderService service) {
        if (this._service == service) {
            this._service = null;
        }
    }
}

