/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.jobmanager.internal.AccessAny;

public class WorkflowAction {
    public static final String KEY_WORKER = "worker";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_INPUT = "input";
    public static final String KEY_OUTPUT = "output";
    private final String _worker;
    private final AnyMap _parameters;
    private final Map<String, String> _input;
    private final Map<String, String> _output;

    public WorkflowAction(AnyMap workflowAction) throws Exception {
        this._worker = AccessAny.getStringRequired(workflowAction, KEY_WORKER);
        this._parameters = (AnyMap)AccessAny.get(workflowAction, KEY_PARAMETERS, Any.ValueType.MAP);
        AnyMap inputAny = (AnyMap)AccessAny.get(workflowAction, KEY_INPUT, Any.ValueType.MAP);
        if (inputAny != null) {
            this._input = new LinkedHashMap<String, String>();
            for (Map.Entry entry : inputAny.entrySet()) {
                this._input.put((String)entry.getKey(), ((Value)entry.getValue()).asString());
            }
        } else {
            this._input = null;
        }
        AnyMap outputAny = (AnyMap)AccessAny.get(workflowAction, KEY_OUTPUT, Any.ValueType.MAP);
        if (outputAny != null) {
            this._output = new LinkedHashMap<String, String>();
            for (Map.Entry entry : outputAny.entrySet()) {
                this._output.put((String)entry.getKey(), ((Value)entry.getValue()).asString());
            }
        } else {
            this._output = null;
        }
    }

    public Any toAny() throws Exception {
        AnyMap workflowActionAny = AccessAny.FACTORY.createAnyMap();
        workflowActionAny.put(KEY_WORKER, this._worker);
        if (this._parameters != null) {
            workflowActionAny.put(KEY_PARAMETERS, (Any)this._parameters);
        }
        if (this._input != null) {
            AnyMap inputAny = AccessAny.FACTORY.createAnyMap();
            for (Map.Entry<String, String> entry : this._input.entrySet()) {
                inputAny.put(entry.getKey(), entry.getValue());
            }
            workflowActionAny.put(KEY_INPUT, (Any)inputAny);
        }
        if (this._output != null) {
            AnyMap outputAny = AccessAny.FACTORY.createAnyMap();
            for (Map.Entry<String, String> entry : this._output.entrySet()) {
                outputAny.put(entry.getKey(), entry.getValue());
            }
            workflowActionAny.put(KEY_OUTPUT, (Any)outputAny);
        }
        return workflowActionAny;
    }

    public String getWorker() {
        return this._worker;
    }

    public AnyMap getParameters() {
        return this._parameters;
    }

    public Map<String, String> getInput() {
        return this._input;
    }

    public Map<String, String> getOutput() {
        return this._output;
    }

    public String toString() {
        try {
            return this.toAny().toString();
        }
        catch (Exception exception) {
            return String.format("%s %s\n\t%s %s\n\t%s %s\n\t%s %s", KEY_WORKER, this._worker, KEY_PARAMETERS, this._parameters, KEY_INPUT, this._input, KEY_OUTPUT, this._output);
        }
    }

    public int hashCode() {
        int hash = this.getWorker().hashCode();
        if (this.getInput() != null) {
            hash += this.getInput().hashCode();
        }
        if (this.getOutput() != null) {
            hash += this.getOutput().hashCode();
        }
        if (this.getParameters() != null) {
            hash += this.getParameters().hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowAction)) {
            return false;
        }
        WorkflowAction wa = (WorkflowAction)o;
        if (!wa.getWorker().equals(this.getWorker())) {
            return false;
        }
        boolean inputEqual = false;
        inputEqual = wa.getInput() != null ? wa.getInput().equals(this.getInput()) : wa.getInput() == null;
        boolean outputEqual = false;
        outputEqual = wa.getOutput() != null ? wa.getOutput().equals(this.getOutput()) : wa.getOutput() == null;
        boolean paramEqual = false;
        if (wa.getParameters() != null) {
            paramEqual = wa.getParameters().equals((Object)this.getParameters());
        } else {
            boolean bl = paramEqual = wa.getParameters() == null;
        }
        return inputEqual && outputEqual && paramEqual;
    }
}

