/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.persistence.DefinitionPersistence;
import org.osgi.service.component.ComponentContext;

public class DataObjectTypesHandler
extends JsonRequestHandler {
    private JobManager _jobManager;
    private DefinitionPersistence _defPersistence;

    protected void activate(ComponentContext context) {
        super.activate(context);
        this._defPersistence = this._jobManager.getDefinitionPersistence();
    }

    protected void deactivate(ComponentContext context) {
        this._defPersistence = null;
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        HashMap resultMap = new HashMap();
        ArrayList dotList = new ArrayList();
        for (String dataObjectTypeName : this._defPersistence.getDataObjectTypes()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", dataObjectTypeName);
            map.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)dataObjectTypeName));
            dotList.add(map);
        }
        resultMap.put("dataObjectTypes", dotList);
        return resultMap;
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

