/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.util.ValueExpression;

public final class AccessAny {
    public static final DataFactory FACTORY = DataFactory.DEFAULT;

    private AccessAny() {
    }

    public static Any get(AnyMap any, String fieldName, Any.ValueType fieldType) throws InvalidConfigException {
        Any field = null;
        field = (Any)any.get((Object)fieldName);
        if (field != null && field.getValueType() != fieldType) {
            throw new InvalidConfigException("Field " + fieldName + " does not have type " + fieldType);
        }
        return field;
    }

    public static ValueExpression getValueExpression(AnyMap any, String fieldName) throws InvalidConfigException {
        String expression = AccessAny.getString(any, fieldName);
        if (expression != null) {
            return new ValueExpression(expression);
        }
        return null;
    }

    public static String getString(AnyMap any, String fieldName) throws InvalidConfigException {
        Value field = (Value)AccessAny.get(any, fieldName, Any.ValueType.STRING);
        if (field != null) {
            return field.asString();
        }
        return null;
    }

    public static AnySeq getSeq(AnyMap any, String fieldName) throws InvalidConfigException {
        Any field = AccessAny.get(any, fieldName, Any.ValueType.SEQ);
        if (field != null) {
            return field.asSeq();
        }
        return null;
    }

    public static boolean getBoolean(AnyMap any, String fieldName, boolean defaultValue) throws InvalidConfigException {
        Any field = (Any)any.get((Object)fieldName);
        if (field == null) {
            return defaultValue;
        }
        if (field.isValue()) {
            try {
                return field.asValue().asBoolean();
            }
            catch (InvalidValueTypeException ex) {
                throw new InvalidConfigException("Field " + fieldName + " does not have a boolean value.", ex);
            }
        }
        throw new InvalidConfigException("Field " + fieldName + " does not have a boolean value.");
    }

    public static ValueExpression getValueExpressionRequired(AnyMap any, String fieldName) throws InvalidConfigException {
        return new ValueExpression(AccessAny.getStringRequired(any, fieldName));
    }

    public static String getStringRequired(AnyMap any, String fieldName) throws InvalidConfigException {
        String value = AccessAny.getString(any, fieldName);
        if (StringUtils.isEmpty((String)value)) {
            throw new InvalidConfigException("Missing field " + fieldName + " or empty value.");
        }
        return value;
    }

    public static List<String> getStringSeq(AnyMap any, String fieldName) throws InvalidConfigException {
        AnySeq field = (AnySeq)AccessAny.get(any, fieldName, Any.ValueType.SEQ);
        ArrayList<String> values = null;
        if (field != null) {
            values = new ArrayList<String>();
            for (Any element : field) {
                if (!element.isString()) {
                    throw new InvalidConfigException("Sequence in field " + fieldName + " must contain strings only");
                }
                values.add(((Value)element).asString());
            }
        }
        return values;
    }
}

