/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.jpa;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.DeploymentUnitDAO;
import org.apache.ode.store.jpa.DeploymentUnitDaoImpl;
import org.apache.ode.store.jpa.VersionTrackerDAOImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfStoreConnectionJpa
implements ConfStoreConnection {
    private EntityManager _em;
    static final ThreadLocal<EntityManager> _current = new ThreadLocal();

    public ConfStoreConnectionJpa(EntityManager entityManager) {
        this._em = entityManager;
        _current.set(entityManager);
    }

    @Override
    public void begin() {
        this._em.getTransaction().begin();
    }

    @Override
    public void close() {
    }

    @Override
    public void commit() {
        this._em.getTransaction().commit();
    }

    @Override
    public DeploymentUnitDAO createDeploymentUnit(String string) {
        DeploymentUnitDaoImpl deploymentUnitDaoImpl = new DeploymentUnitDaoImpl();
        deploymentUnitDaoImpl.setName(string);
        deploymentUnitDaoImpl.setDeployDate(new Date());
        this._em.persist((Object)deploymentUnitDaoImpl);
        return deploymentUnitDaoImpl;
    }

    @Override
    public DeploymentUnitDAO getDeploymentUnit(String string) {
        return (DeploymentUnitDAO)this._em.find(DeploymentUnitDaoImpl.class, (Object)string);
    }

    @Override
    public Collection<DeploymentUnitDAO> getDeploymentUnits() {
        return this._em.createQuery("SELECT du from org.apache.ode.store.jpa.DeploymentUnitDaoImpl du").getResultList();
    }

    @Override
    public void rollback() {
        this._em.getTransaction().rollback();
    }

    @Override
    public long getNextVersion() {
        List list = this._em.createQuery("select v from VersionTrackerDAOImpl v").getResultList();
        if (list.size() == 0) {
            return 1L;
        }
        VersionTrackerDAOImpl versionTrackerDAOImpl = (VersionTrackerDAOImpl)list.get(0);
        return versionTrackerDAOImpl.getVersion() + 1L;
    }

    @Override
    public void setVersion(long l) {
        List list = this._em.createQuery("select v from VersionTrackerDAOImpl v").getResultList();
        VersionTrackerDAOImpl versionTrackerDAOImpl = list.size() == 0 ? new VersionTrackerDAOImpl() : (VersionTrackerDAOImpl)list.get(0);
        versionTrackerDAOImpl.setVersion(l);
        this._em.persist((Object)versionTrackerDAOImpl);
    }
}

