/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.TaskLog;
import org.eclipse.smila.taskworker.TaskLogFactory;

public class DefaultTaskLogFactory
implements TaskLogFactory {
    private final Log _log = LogFactory.getLog(this.getClass());

    @Override
    public TaskLog getTaskLog(final Task task) {
        return new TaskLog(){
            private int _infoCount;
            private int _warnCount;
            private int _errorCount;

            @Override
            public void error(String message, AnyMap details) {
                ++this._errorCount;
                DefaultTaskLogFactory.this._log.error((Object)("Task " + task.getTaskId() + ": " + message + "; Details: " + details));
            }

            @Override
            public void error(String message, Throwable error) {
                ++this._errorCount;
                DefaultTaskLogFactory.this._log.error((Object)("Task " + task.getTaskId() + ": " + message), error);
            }

            @Override
            public void error(String message) {
                ++this._errorCount;
                DefaultTaskLogFactory.this._log.error((Object)("Task " + task.getTaskId() + ": " + message));
            }

            @Override
            public void warn(String message, AnyMap details) {
                ++this._warnCount;
                DefaultTaskLogFactory.this._log.warn((Object)("Task " + task.getTaskId() + ": " + message + "; Details: " + details));
            }

            @Override
            public void warn(String message, Throwable error) {
                ++this._warnCount;
                DefaultTaskLogFactory.this._log.warn((Object)("Task " + task.getTaskId() + ": " + message), error);
            }

            @Override
            public void warn(String message) {
                ++this._warnCount;
                DefaultTaskLogFactory.this._log.warn((Object)("Task " + task.getTaskId() + ": " + message));
            }

            @Override
            public void info(String message, AnyMap details) {
                ++this._infoCount;
                DefaultTaskLogFactory.this._log.info((Object)("Task " + task.getTaskId() + ": " + message + "; Details: " + details));
            }

            @Override
            public void info(String message, Throwable error) {
                ++this._infoCount;
                DefaultTaskLogFactory.this._log.info((Object)("Task " + task.getTaskId() + ": " + message), error);
            }

            @Override
            public void info(String message) {
                ++this._infoCount;
                DefaultTaskLogFactory.this._log.info((Object)("Task " + task.getTaskId() + ": " + message));
            }

            @Override
            public int getWarnCount() {
                return this._warnCount;
            }

            @Override
            public int getInfoCount() {
                return this._infoCount;
            }

            @Override
            public int getErrorCount() {
                return this._errorCount;
            }
        };
    }
}

