/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.input;

import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.Counters;
import org.eclipse.smila.taskworker.input.Input;

public class StreamInput
extends Input {
    private CountingInputStream _stream;

    public StreamInput(BulkInfo dataObject, ObjectStoreService objectStore) {
        super(dataObject, objectStore);
    }

    public InputStream getStream() throws ObjectStoreException {
        if (this._stream == null) {
            long start = this.startTime();
            InputStream objectStream = ObjectStoreRetryUtil.retryReadObject((ObjectStoreService)this.getObjectStore(), (String)this.getStoreName(), (String)this.getObjectName());
            this._stream = new CountingInputStream(objectStream);
            this.timeOpen(start);
        }
        return this._stream;
    }

    @Override
    public void close() {
        if (this._stream != null) {
            IOUtils.closeQuietly((InputStream)this._stream);
        }
    }

    public long getBytesRead() {
        if (this._stream != null) {
            return this._stream.getByteCount();
        }
        return 0L;
    }

    @Override
    public Map<String, Number> getCounter() {
        Map<String, Number> counter = super.getCounter();
        Counters.add(counter, "size", this.getBytesRead());
        return counter;
    }

    public String toString() {
        return "StreamInput: store = " + this.getStoreName() + ", object = " + this.getObjectName();
    }
}

