/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2.xpath20;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpression;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.xpath.XPathExpressionImpl;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPath20ExpressionModifier {
    private NSContext contextUris;
    private NamePool namePool;

    public XPath20ExpressionModifier(NSContext nSContext, NamePool namePool) {
        this.contextUris = nSContext;
        this.namePool = namePool;
    }

    public void insertMissingData(XPathExpression xPathExpression, Node object) throws DOMException, TransformerException {
        if (object == null || !(object instanceof Element) || !(xPathExpression instanceof XPathExpressionImpl)) {
            return;
        }
        Expression expression = ((XPathExpressionImpl)xPathExpression).getInternalExpression();
        Iterator iterator = expression.iterateSubExpressions();
        if (!iterator.hasNext()) {
            return;
        }
        Expression expression2 = (Expression)iterator.next();
        if (!(expression2 instanceof PathExpression)) {
            return;
        }
        Document document = DOMUtils.toDOMDocument((Node)object);
        PathExpression pathExpression = (PathExpression)expression2;
        Expression expression3 = pathExpression.getFirstStep();
        while (expression3 != null) {
            NodeTest nodeTest;
            AxisExpression axisExpression;
            if (expression3 instanceof AxisExpression) {
                Object object2;
                axisExpression = (AxisExpression)expression3;
                nodeTest = axisExpression.getNodeTest();
                if (!(nodeTest instanceof NameTest)) break;
                NameTest nameTest = (NameTest)nodeTest;
                QName qName = this.getQualifiedName(nameTest.getFingerprint(), this.namePool, this.contextUris);
                if (3 == axisExpression.getAxis()) {
                    if (NodeKindTest.ELEMENT.getNodeKindMask() != nameTest.getNodeKindMask()) break;
                    object2 = ((Element)object).getElementsByTagNameNS(qName.getNamespaceURI(), qName.getLocalPart());
                    if (object2 == null || object2.getLength() == 0) {
                        Element element = document.createElementNS(qName.getNamespaceURI(), DOMUtils.getQualifiedName((QName)qName));
                        object.appendChild(element);
                        object = element;
                    } else {
                        if (object2.getLength() != 1) break;
                        object = object2.item(0);
                    }
                } else {
                    if (2 != axisExpression.getAxis() || NodeKindTest.ATTRIBUTE.getNodeKindMask() != nameTest.getNodeKindMask() || (object2 = ((Element)object).getAttributeNodeNS(qName.getNamespaceURI(), qName.getLocalPart())) != null) break;
                    object2 = document.createAttributeNS(qName.getNamespaceURI(), qName.getLocalPart());
                    ((Element)object).setAttributeNode((Attr)object2);
                    object = object2;
                }
            } else if (!(expression3 instanceof ItemChecker) || !((nodeTest = (axisExpression = (ItemChecker)expression3).getBaseExpression()) instanceof VariableReference)) break;
            if (pathExpression == null) break;
            axisExpression = pathExpression.getRemainingSteps();
            if (axisExpression instanceof PathExpression) {
                pathExpression = (PathExpression)axisExpression;
                expression3 = pathExpression.getFirstStep();
                continue;
            }
            if (!(axisExpression instanceof AxisExpression)) continue;
            pathExpression = null;
            expression3 = axisExpression;
        }
    }

    private QName getQualifiedName(int n, NamePool namePool, NSContext nSContext) {
        String string = namePool.getLocalName(n);
        String string2 = namePool.getPrefix(n);
        String string3 = namePool.getURI(n);
        if (string2 == null || "".equals(string2)) {
            for (String string4 : nSContext.getPrefixes()) {
                String string5 = nSContext.getNamespaceURI(string4);
                if (!string5.equals(string3)) continue;
                string2 = string4;
            }
        }
        return new QName(string3, string, string2);
    }
}

