/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.processing.PipeletTrackerListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.ComponentContext;

public class PipeletTrackerImpl
implements SynchronousBundleListener,
PipeletTracker {
    private static final String MANIFEST_SMILA_PIPELETS = "SMILA-Pipelets";
    private final Log _log = LogFactory.getLog(PipeletTrackerImpl.class);
    private final Map<String, Map<String, Class<? extends Pipelet>>> _knownPipelets = new HashMap<String, Map<String, Class<? extends Pipelet>>>();
    private final Collection<PipeletTrackerListener> _listeners = new ArrayList<PipeletTrackerListener>();

    @Override
    public Map<String, Class<? extends Pipelet>> getRegisteredPipelets() {
        HashMap<String, Class<? extends Pipelet>> registeredPipelets = new HashMap<String, Class<? extends Pipelet>>();
        for (Map<String, Class<? extends Pipelet>> bundlePipelets : this._knownPipelets.values()) {
            registeredPipelets.putAll(bundlePipelets);
        }
        return registeredPipelets;
    }

    @Override
    public void addListener(PipeletTrackerListener listener) {
        this._listeners.add(listener);
        for (Map<String, Class<? extends Pipelet>> pipeletClassNames : this._knownPipelets.values()) {
            listener.pipeletsAdded(pipeletClassNames);
        }
    }

    @Override
    public void removeListener(PipeletTrackerListener listener) {
        this._listeners.remove(listener);
    }

    protected void activate(ComponentContext componentContext) {
        Bundle[] bundles;
        BundleContext bundleContext = componentContext.getBundleContext();
        bundleContext.addBundleListener((BundleListener)this);
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 0x2C) > 0) {
                this.bundleAdded(bundle);
            }
            ++n2;
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        BundleContext bundleContext = componentContext.getBundleContext();
        bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 32: {
                this.bundleAdded(event.getBundle());
                break;
            }
            case 128: {
                this.bundleAdded(event.getBundle());
                break;
            }
            case 256: {
                this.bundleRemoved(event.getBundle());
            }
        }
    }

    private void bundleAdded(Bundle bundle) {
        String bundleName = bundle.getSymbolicName();
        if (this._knownPipelets.containsKey(bundleName)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Pipelets from bundle " + bundleName + " have been loaded already, skipping."));
            }
        } else {
            String pipeletManifest = (String)bundle.getHeaders().get(MANIFEST_SMILA_PIPELETS);
            if (pipeletManifest != null) {
                String[] pipeletManifestEntries;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Found manifest header SMILA-Pipelets = " + pipeletManifest + " in bundle " + bundleName));
                }
                HashMap<String, Class<? extends Pipelet>> pipeletClasses = new HashMap<String, Class<? extends Pipelet>>();
                String[] stringArray = pipeletManifestEntries = pipeletManifest.split(",");
                int n = pipeletManifestEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    String pipeletClassName = stringArray[n2];
                    this.loadPipeletClass(pipeletClasses, pipeletClassName, bundle);
                    ++n2;
                }
                if (!pipeletClasses.isEmpty()) {
                    this._knownPipelets.put(bundleName, pipeletClasses);
                    for (PipeletTrackerListener listener : this._listeners) {
                        listener.pipeletsAdded(pipeletClasses);
                    }
                }
            }
        }
    }

    private void loadPipeletClass(Map<String, Class<? extends Pipelet>> pipeletClasses, String pipeletClassName, Bundle bundle) {
        String trimmedClassName = pipeletClassName.trim();
        if (trimmedClassName.length() > 0) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Found pipelet class name = " + trimmedClassName));
            }
            try {
                Class pipeletClass = bundle.loadClass(trimmedClassName);
                pipeletClasses.put(trimmedClassName, pipeletClass);
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Pipelet class " + trimmedClassName + " loaded."));
                }
            }
            catch (ClassNotFoundException ex) {
                this._log.error((Object)("Pipelet class " + trimmedClassName + " could not be loaded from bundle " + bundle.getSymbolicName()), (Throwable)ex);
            }
        }
    }

    private void bundleRemoved(Bundle bundle) {
        String bundleName = bundle.getSymbolicName();
        if (this._knownPipelets.containsKey(bundleName)) {
            Map<String, Class<? extends Pipelet>> pipeletClassNames = this._knownPipelets.remove(bundleName);
            for (PipeletTrackerListener listener : this._listeners) {
                listener.pipeletsRemoved(pipeletClassNames);
            }
        }
    }
}

