/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.param.set;

import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.set.DBoolean;
import org.eclipse.smila.search.utils.param.set.DBooleanCodec;
import org.eclipse.smila.search.utils.param.set.DDate;
import org.eclipse.smila.search.utils.param.set.DDateCodec;
import org.eclipse.smila.search.utils.param.set.DDateList;
import org.eclipse.smila.search.utils.param.set.DDateListCodec;
import org.eclipse.smila.search.utils.param.set.DFloat;
import org.eclipse.smila.search.utils.param.set.DFloatCodec;
import org.eclipse.smila.search.utils.param.set.DFloatList;
import org.eclipse.smila.search.utils.param.set.DFloatListCodec;
import org.eclipse.smila.search.utils.param.set.DInteger;
import org.eclipse.smila.search.utils.param.set.DIntegerCodec;
import org.eclipse.smila.search.utils.param.set.DIntegerList;
import org.eclipse.smila.search.utils.param.set.DIntegerListCodec;
import org.eclipse.smila.search.utils.param.set.DParameter;
import org.eclipse.smila.search.utils.param.set.DString;
import org.eclipse.smila.search.utils.param.set.DStringCodec;
import org.eclipse.smila.search.utils.param.set.DStringList;
import org.eclipse.smila.search.utils.param.set.DStringListCodec;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Element;

public abstract class DParameterCodec {
    private DParameterCodec() {
    }

    public static DParameter decode(Element element) throws ParameterException {
        String type = element.getAttribute("xsi:type");
        type = XMLUtils.getLocalPart((String)type);
        DParameter dParameter = null;
        if ("Float".equals(type)) {
            dParameter = DFloatCodec.decode(element);
        } else if ("Date".equals(type)) {
            dParameter = DDateCodec.decode(element);
        } else if ("String".equals(type)) {
            dParameter = DStringCodec.decode(element);
        } else if ("Integer".equals(type)) {
            dParameter = DIntegerCodec.decode(element);
        } else if ("Boolean".equals(type)) {
            dParameter = DBooleanCodec.decode(element);
        } else if ("FloatList".equals(type)) {
            dParameter = DFloatListCodec.decode(element);
        } else if ("DateList".equals(type)) {
            dParameter = DDateListCodec.decode(element);
        } else if ("StringList".equals(type)) {
            dParameter = DStringListCodec.decode(element);
        } else if ("IntegerList".equals(type)) {
            dParameter = DIntegerListCodec.decode(element);
        } else {
            throw new ParameterException("Unknown parameter type [" + type + "]");
        }
        dParameter.setName(element.getAttribute("Name"));
        dParameter.setType(type);
        return dParameter;
    }

    public static Element encode(DParameter dParameter, Element element) throws ParameterException {
        Element el = null;
        if (dParameter instanceof DFloat) {
            el = DFloatCodec.encode((DFloat)dParameter, element);
        } else if (dParameter instanceof DDate) {
            el = DDateCodec.encode((DDate)dParameter, element);
        } else if (dParameter instanceof DString) {
            el = DStringCodec.encode((DString)dParameter, element);
        } else if (dParameter instanceof DInteger) {
            el = DIntegerCodec.encode((DInteger)dParameter, element);
        } else if (dParameter instanceof DBoolean) {
            el = DBooleanCodec.encode((DBoolean)dParameter, element);
        } else if (dParameter instanceof DFloatList) {
            el = DFloatListCodec.encode((DFloatList)dParameter, element);
        } else if (dParameter instanceof DDateList) {
            el = DDateListCodec.encode((DDateList)dParameter, element);
        } else if (dParameter instanceof DStringList) {
            el = DStringListCodec.encode((DStringList)dParameter, element);
        } else if (dParameter instanceof DIntegerList) {
            el = DIntegerListCodec.encode((DIntegerList)dParameter, element);
        } else {
            throw new ParameterException("Unknown parameter type [" + dParameter.getClass() + "]");
        }
        el.setAttribute("Name", dParameter.getName());
        String type = dParameter.getType();
        if (dParameter.getType().equals("Enumeration")) {
            type = dParameter instanceof DString ? "String" : "StringList";
        }
        el.setAttribute("xsi:type", type);
        element.appendChild(el);
        return el;
    }
}

